/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.SocketImpl;

public class PrependableSocket
extends Socket {
    private PushbackInputStream pushbackInputStream;

    public PrependableSocket(SocketImpl base) throws IOException {
        super(base);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.pushbackInputStream == null) {
            return super.getInputStream();
        }
        return this.pushbackInputStream;
    }

    public void prependToInputStream(byte[] bytes2, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this.pushbackInputStream != null) {
            throw new IOException("prependToInputStream() called more than once");
        }
        PushbackInputStream pushbackInputStream = new PushbackInputStream(this.getInputStream(), length);
        pushbackInputStream.unread(bytes2, offset, length);
        this.pushbackInputStream = pushbackInputStream;
    }
}

