/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.quorum.flexible;

import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumHierarchical
implements QuorumVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumHierarchical.class);
    private HashMap<Long, Long> serverWeight = new HashMap();
    private HashMap<Long, Long> serverGroup = new HashMap();
    private HashMap<Long, Long> groupWeight = new HashMap();
    private int numGroups = 0;
    private Map<Long, QuorumPeer.QuorumServer> allMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private Map<Long, QuorumPeer.QuorumServer> participatingMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private Map<Long, QuorumPeer.QuorumServer> observingMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private long version = 0L;

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof QuorumHierarchical)) {
            return false;
        }
        QuorumHierarchical qm = (QuorumHierarchical)o;
        if (qm.getVersion() == this.version) {
            return true;
        }
        if (this.allMembers.size() != qm.getAllMembers().size() || this.serverWeight.size() != qm.serverWeight.size() || this.groupWeight.size() != qm.groupWeight.size() || this.serverGroup.size() != qm.serverGroup.size()) {
            return false;
        }
        for (QuorumPeer.QuorumServer quorumServer : this.allMembers.values()) {
            QuorumPeer.QuorumServer qso = qm.getAllMembers().get(quorumServer.id);
            if (qso != null && quorumServer.equals(qso)) continue;
            return false;
        }
        for (Map.Entry entry : this.serverWeight.entrySet()) {
            if (((Long)entry.getValue()).equals(qm.serverWeight.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry entry : this.groupWeight.entrySet()) {
            if (((Long)entry.getValue()).equals(qm.groupWeight.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry entry : this.serverGroup.entrySet()) {
            if (((Long)entry.getValue()).equals(qm.serverGroup.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public QuorumHierarchical(String filename) throws QuorumPeerConfig.ConfigException {
        this.readConfigFile(filename);
    }

    public QuorumHierarchical(Properties qp) throws QuorumPeerConfig.ConfigException {
        this.parse(qp);
        LOG.info("{}, {}, {}", this.serverWeight.size(), this.serverGroup.size(), this.groupWeight.size());
    }

    @Override
    public long getWeight(long id) {
        return this.serverWeight.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigFile(String filename) throws QuorumPeerConfig.ConfigException {
        File configFile = new File(filename);
        LOG.info("Reading configuration from: {}", (Object)configFile);
        try {
            if (!configFile.exists()) {
                throw new IllegalArgumentException(configFile.toString() + " file is missing");
            }
            Properties cfg2 = new Properties();
            try (FileInputStream in = new FileInputStream(configFile);){
                cfg2.load(in);
            }
            this.parse(cfg2);
        }
        catch (IOException e2) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + filename, e2);
        }
        catch (IllegalArgumentException e3) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + filename, e3);
        }
    }

    private void parse(Properties quorumProp) throws QuorumPeerConfig.ConfigException {
        for (Map.Entry<Object, Object> entry : quorumProp.entrySet()) {
            long sid;
            int dot;
            String key2 = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key2.startsWith("server.")) {
                dot = key2.indexOf(46);
                sid = Long.parseLong(key2.substring(dot + 1));
                QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(sid, value);
                this.allMembers.put(sid, qs);
                if (qs.type == QuorumPeer.LearnerType.PARTICIPANT) {
                    this.participatingMembers.put(sid, qs);
                    continue;
                }
                this.observingMembers.put(sid, qs);
                continue;
            }
            if (key2.startsWith("group")) {
                String[] parts;
                dot = key2.indexOf(46);
                long gid = Long.parseLong(key2.substring(dot + 1));
                ++this.numGroups;
                for (String s : parts = value.split(":")) {
                    long sid2 = Long.parseLong(s);
                    if (this.serverGroup.containsKey(sid2)) {
                        throw new QuorumPeerConfig.ConfigException("Server " + sid2 + "is in multiple groups");
                    }
                    this.serverGroup.put(sid2, gid);
                }
                continue;
            }
            if (key2.startsWith("weight")) {
                dot = key2.indexOf(46);
                sid = Long.parseLong(key2.substring(dot + 1));
                this.serverWeight.put(sid, Long.parseLong(value));
                continue;
            }
            if (!key2.equals("version")) continue;
            this.version = Long.parseLong(value, 16);
        }
        for (QuorumPeer.QuorumServer qs : this.allMembers.values()) {
            Long id = qs.id;
            if (qs.type != QuorumPeer.LearnerType.PARTICIPANT) continue;
            if (!this.serverGroup.containsKey(id)) {
                throw new QuorumPeerConfig.ConfigException("Server " + id + "is not in a group");
            }
            if (this.serverWeight.containsKey(id)) continue;
            this.serverWeight.put(id, 1L);
        }
        this.computeGroupWeight();
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getAllMembers() {
        return this.allMembers;
    }

    @Override
    public String toString() {
        String value;
        Long sid;
        StringWriter sw = new StringWriter();
        for (QuorumPeer.QuorumServer member : this.getAllMembers().values()) {
            String string2 = "server." + member.id;
            String value2 = member.toString();
            sw.append(string2);
            sw.append('=');
            sw.append(value2);
            sw.append('\n');
        }
        HashMap<Long, String> groups = new HashMap<Long, String>();
        for (Map.Entry<Long, Long> entry : this.serverGroup.entrySet()) {
            sid = entry.getKey();
            Long gid = entry.getValue();
            String str2 = (String)groups.get(gid);
            str2 = str2 == null ? sid.toString() : str2.concat(":").concat(sid.toString());
            groups.put(gid, str2);
        }
        for (Map.Entry<Long, Long> entry : groups.entrySet()) {
            Long gid = entry.getKey();
            String key2 = "group." + gid.toString();
            value = (String)((Object)entry.getValue());
            sw.append(key2);
            sw.append('=');
            sw.append(value);
            sw.append('\n');
        }
        for (Map.Entry<Long, Long> entry : this.serverWeight.entrySet()) {
            sid = entry.getKey();
            String key2 = "weight." + sid.toString();
            value = entry.getValue().toString();
            sw.append(key2);
            sw.append('=');
            sw.append(value);
            sw.append('\n');
        }
        sw.append("version=" + Long.toHexString(this.version));
        return sw.toString();
    }

    private void computeGroupWeight() {
        for (Map.Entry<Long, Long> entry : this.serverGroup.entrySet()) {
            Long sid = entry.getKey();
            Long gid = entry.getValue();
            if (!this.groupWeight.containsKey(gid)) {
                this.groupWeight.put(gid, this.serverWeight.get(sid));
                continue;
            }
            long totalWeight = this.serverWeight.get(sid) + this.groupWeight.get(gid);
            this.groupWeight.put(gid, totalWeight);
        }
        Iterator<Object> iterator = this.groupWeight.values().iterator();
        while (iterator.hasNext()) {
            long weight = (Long)iterator.next();
            LOG.debug("Group weight: {}", (Object)weight);
            if (weight != 0L) continue;
            --this.numGroups;
            LOG.debug("One zero-weight group: 1, {}", (Object)this.numGroups);
        }
    }

    @Override
    public boolean containsQuorum(Set<Long> set2) {
        Long gid;
        HashMap<Long, Long> expansion = new HashMap<Long, Long>();
        LOG.debug("Set size: {}", (Object)set2.size());
        if (set2.size() == 0) {
            return false;
        }
        for (long sid : set2) {
            gid = this.serverGroup.get(sid);
            if (gid == null) continue;
            if (!expansion.containsKey(gid)) {
                expansion.put(gid, this.serverWeight.get(sid));
                continue;
            }
            long totalWeight = this.serverWeight.get(sid) + (Long)expansion.get(gid);
            expansion.put(gid, totalWeight);
        }
        int majGroupCounter = 0;
        for (Map.Entry entry : expansion.entrySet()) {
            gid = (Long)entry.getKey();
            LOG.debug("Group info: {}, {}, {}", entry.getValue(), gid, this.groupWeight.get(gid));
            if ((Long)entry.getValue() <= this.groupWeight.get(gid) / 2L) continue;
            ++majGroupCounter;
        }
        LOG.debug("Majority group counter: {}, {}", (Object)majGroupCounter, (Object)this.numGroups);
        if (majGroupCounter > this.numGroups / 2) {
            LOG.debug("Positive set size: {}", (Object)set2.size());
            return true;
        }
        LOG.debug("Negative set size: {}", (Object)set2.size());
        return false;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getVotingMembers() {
        return this.participatingMembers;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getObservingMembers() {
        return this.observingMembers;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long ver) {
        this.version = ver;
    }
}

