/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.util;

import io.mantisrx.shaded.org.apache.jute.BinaryInputArchive;
import io.mantisrx.shaded.org.apache.jute.InputArchive;
import io.mantisrx.shaded.org.apache.jute.OutputArchive;
import io.mantisrx.shaded.org.apache.jute.Record;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataTree;
import io.mantisrx.shaded.org.apache.zookeeper.server.Request;
import io.mantisrx.shaded.org.apache.zookeeper.server.TxnLogEntry;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooTrace;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.Util;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CloseSessionTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateContainerTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateSessionTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateTTLTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateTxnV0;
import io.mantisrx.shaded.org.apache.zookeeper.txn.DeleteTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.ErrorTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.MultiTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.SetACLTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.SetDataTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.TxnDigest;
import io.mantisrx.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SerializeUtils.class);

    public static TxnLogEntry deserializeTxn(byte[] txnBytes) throws IOException {
        TxnHeader hdr = new TxnHeader();
        ByteArrayInputStream bais = new ByteArrayInputStream(txnBytes);
        BinaryInputArchive ia = BinaryInputArchive.getArchive(bais);
        hdr.deserialize(ia, "hdr");
        bais.mark(bais.available());
        Record txn = null;
        switch (hdr.getType()) {
            case -10: {
                txn = new CreateSessionTxn();
                break;
            }
            case -11: {
                txn = ZooKeeperServer.isCloseSessionTxnEnabled() ? new CloseSessionTxn() : null;
                break;
            }
            case 1: 
            case 15: {
                txn = new CreateTxn();
                break;
            }
            case 21: {
                txn = new CreateTTLTxn();
                break;
            }
            case 19: {
                txn = new CreateContainerTxn();
                break;
            }
            case 2: 
            case 20: {
                txn = new DeleteTxn();
                break;
            }
            case 5: 
            case 16: {
                txn = new SetDataTxn();
                break;
            }
            case 7: {
                txn = new SetACLTxn();
                break;
            }
            case -1: {
                txn = new ErrorTxn();
                break;
            }
            case 14: {
                txn = new MultiTxn();
                break;
            }
            default: {
                throw new IOException("Unsupported Txn with type=%d" + hdr.getType());
            }
        }
        if (txn != null) {
            try {
                txn.deserialize(ia, "txn");
            }
            catch (EOFException e2) {
                if (hdr.getType() == 1) {
                    CreateTxn create = (CreateTxn)txn;
                    bais.reset();
                    CreateTxnV0 createv0 = new CreateTxnV0();
                    createv0.deserialize(ia, "txn");
                    create.setPath(createv0.getPath());
                    create.setData(createv0.getData());
                    create.setAcl(createv0.getAcl());
                    create.setEphemeral(createv0.getEphemeral());
                    create.setParentCVersion(-1);
                }
                if (hdr.getType() == -11) {
                    txn = null;
                }
                throw e2;
            }
        }
        TxnDigest digest = null;
        if (ZooKeeperServer.isDigestEnabled()) {
            digest = new TxnDigest();
            try {
                digest.deserialize(ia, "digest");
            }
            catch (EOFException exception) {
                digest = null;
            }
        }
        return new TxnLogEntry(txn, hdr, digest);
    }

    public static void deserializeSnapshot(DataTree dt, InputArchive ia, Map<Long, Integer> sessions) throws IOException {
        for (int count2 = ia.readInt("count"); count2 > 0; --count2) {
            long id = ia.readLong("id");
            int to = ia.readInt("timeout");
            sessions.put(id, to);
            if (!LOG.isTraceEnabled()) continue;
            ZooTrace.logTraceMessage(LOG, 32L, "loadData --- session in archive: " + id + " with timeout: " + to);
        }
        dt.deserialize(ia, "tree");
    }

    public static void serializeSnapshot(DataTree dt, OutputArchive oa, Map<Long, Integer> sessions) throws IOException {
        HashMap<Long, Integer> sessSnap = new HashMap<Long, Integer>(sessions);
        oa.writeInt(sessSnap.size(), "count");
        for (Map.Entry<Long, Integer> entry : sessSnap.entrySet()) {
            oa.writeLong(entry.getKey(), "id");
            oa.writeInt(entry.getValue(), "timeout");
        }
        dt.serialize(oa, "tree");
    }

    public static byte[] serializeRequest(Request request) {
        if (request == null || request.getHdr() == null) {
            return null;
        }
        byte[] data2 = new byte[32];
        try {
            data2 = Util.marshallTxnEntry(request.getHdr(), request.getTxn(), request.getTxnDigest());
        }
        catch (IOException e2) {
            LOG.error("This really should be impossible", e2);
        }
        return data2;
    }
}

