/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.watch;

import io.mantisrx.shaded.org.apache.zookeeper.WatchedEvent;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooTrace;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.IWatchManager;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.PathParentIterator;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatcherMode;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatcherModeManager;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatcherOrBitSet;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatchesPathReport;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatchesReport;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatchesSummary;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchManager
implements IWatchManager {
    private static final Logger LOG = LoggerFactory.getLogger(WatchManager.class);
    private final Map<String, Set<Watcher>> watchTable = new HashMap<String, Set<Watcher>>();
    private final Map<Watcher, Set<String>> watch2Paths = new HashMap<Watcher, Set<String>>();
    private final WatcherModeManager watcherModeManager = new WatcherModeManager();

    @Override
    public synchronized int size() {
        int result = 0;
        for (Set<Watcher> watches : this.watchTable.values()) {
            result += watches.size();
        }
        return result;
    }

    private boolean isDeadWatcher(Watcher watcher) {
        return watcher instanceof ServerCnxn && ((ServerCnxn)watcher).isStale();
    }

    @Override
    public boolean addWatch(String path2, Watcher watcher) {
        return this.addWatch(path2, watcher, WatcherMode.DEFAULT_WATCHER_MODE);
    }

    @Override
    public synchronized boolean addWatch(String path2, Watcher watcher, WatcherMode watcherMode) {
        if (this.isDeadWatcher(watcher)) {
            LOG.debug("Ignoring addWatch with closed cnxn");
            return false;
        }
        Set<Watcher> list = this.watchTable.get(path2);
        if (list == null) {
            list = new HashSet<Watcher>(4);
            this.watchTable.put(path2, list);
        }
        list.add(watcher);
        Set<String> paths = this.watch2Paths.get(watcher);
        if (paths == null) {
            paths = new HashSet<String>();
            this.watch2Paths.put(watcher, paths);
        }
        this.watcherModeManager.setWatcherMode(watcher, path2, watcherMode);
        return paths.add(path2);
    }

    @Override
    public synchronized void removeWatcher(Watcher watcher) {
        Set<String> paths = this.watch2Paths.remove(watcher);
        if (paths == null) {
            return;
        }
        for (String p : paths) {
            Set<Watcher> list = this.watchTable.get(p);
            if (list != null) {
                list.remove(watcher);
                if (list.isEmpty()) {
                    this.watchTable.remove(p);
                }
            }
            this.watcherModeManager.removeWatcher(watcher, p);
        }
    }

    @Override
    public WatcherOrBitSet triggerWatch(String path2, Watcher.Event.EventType type2) {
        return this.triggerWatch(path2, type2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatcherOrBitSet triggerWatch(String path2, Watcher.Event.EventType type2, WatcherOrBitSet supress) {
        WatchedEvent e2 = new WatchedEvent(type2, Watcher.Event.KeeperState.SyncConnected, path2);
        HashSet<Watcher> watchers = new HashSet<Watcher>();
        PathParentIterator pathParentIterator = this.getPathParentIterator(path2);
        WatchManager watchManager = this;
        synchronized (watchManager) {
            for (String localPath : pathParentIterator.asIterable()) {
                Set<Watcher> thisWatchers = this.watchTable.get(localPath);
                if (thisWatchers == null || thisWatchers.isEmpty()) continue;
                Iterator<Watcher> iterator = thisWatchers.iterator();
                while (iterator.hasNext()) {
                    Watcher watcher = iterator.next();
                    WatcherMode watcherMode = this.watcherModeManager.getWatcherMode(watcher, localPath);
                    if (watcherMode.isRecursive()) {
                        if (type2 == Watcher.Event.EventType.NodeChildrenChanged) continue;
                        watchers.add(watcher);
                        continue;
                    }
                    if (pathParentIterator.atParentPath()) continue;
                    watchers.add(watcher);
                    if (watcherMode.isPersistent()) continue;
                    iterator.remove();
                    Set<String> paths = this.watch2Paths.get(watcher);
                    if (paths == null) continue;
                    paths.remove(localPath);
                }
                if (!thisWatchers.isEmpty()) continue;
                this.watchTable.remove(localPath);
            }
        }
        if (watchers.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                ZooTrace.logTraceMessage(LOG, 64L, "No watchers for " + path2);
            }
            return null;
        }
        for (Watcher w : watchers) {
            if (supress != null && supress.contains(w)) continue;
            w.process(e2);
        }
        switch (type2) {
            case NodeCreated: {
                ServerMetrics.getMetrics().NODE_CREATED_WATCHER.add(watchers.size());
                break;
            }
            case NodeDeleted: {
                ServerMetrics.getMetrics().NODE_DELETED_WATCHER.add(watchers.size());
                break;
            }
            case NodeDataChanged: {
                ServerMetrics.getMetrics().NODE_CHANGED_WATCHER.add(watchers.size());
                break;
            }
            case NodeChildrenChanged: {
                ServerMetrics.getMetrics().NODE_CHILDREN_WATCHER.add(watchers.size());
                break;
            }
        }
        return new WatcherOrBitSet(watchers);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.watch2Paths.size()).append(" connections watching ").append(this.watchTable.size()).append(" paths\n");
        int total = 0;
        for (Set<String> paths : this.watch2Paths.values()) {
            total += paths.size();
        }
        sb.append("Total watches:").append(total);
        return sb.toString();
    }

    @Override
    public synchronized void dumpWatches(PrintWriter pwriter, boolean byPath) {
        if (byPath) {
            for (Map.Entry<String, Set<Watcher>> e2 : this.watchTable.entrySet()) {
                pwriter.println(e2.getKey());
                for (Watcher w : e2.getValue()) {
                    pwriter.print("\t0x");
                    pwriter.print(Long.toHexString(((ServerCnxn)w).getSessionId()));
                    pwriter.print("\n");
                }
            }
        } else {
            for (Map.Entry<Watcher, Set<String>> e3 : this.watch2Paths.entrySet()) {
                pwriter.print("0x");
                pwriter.println(Long.toHexString(((ServerCnxn)e3.getKey()).getSessionId()));
                for (String path2 : e3.getValue()) {
                    pwriter.print("\t");
                    pwriter.println(path2);
                }
            }
        }
    }

    @Override
    public synchronized boolean containsWatcher(String path2, Watcher watcher) {
        WatcherMode watcherMode = this.watcherModeManager.getWatcherMode(watcher, path2);
        PathParentIterator pathParentIterator = this.getPathParentIterator(path2);
        for (String localPath : pathParentIterator.asIterable()) {
            Set<Watcher> watchers = this.watchTable.get(localPath);
            if (!pathParentIterator.atParentPath() && watchers != null) {
                return true;
            }
            if (!watcherMode.isRecursive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeWatcher(String path2, Watcher watcher) {
        Set<String> paths = this.watch2Paths.get(watcher);
        if (paths == null || !paths.remove(path2)) {
            return false;
        }
        Set<Watcher> list = this.watchTable.get(path2);
        if (list == null || !list.remove(watcher)) {
            return false;
        }
        if (list.isEmpty()) {
            this.watchTable.remove(path2);
        }
        this.watcherModeManager.removeWatcher(watcher, path2);
        return true;
    }

    @Override
    public synchronized WatchesReport getWatches() {
        HashMap<Long, Set<String>> id2paths = new HashMap<Long, Set<String>>();
        for (Map.Entry<Watcher, Set<String>> e2 : this.watch2Paths.entrySet()) {
            Long id = ((ServerCnxn)e2.getKey()).getSessionId();
            HashSet paths = new HashSet(e2.getValue());
            id2paths.put(id, paths);
        }
        return new WatchesReport(id2paths);
    }

    @Override
    public synchronized WatchesPathReport getWatchesByPath() {
        HashMap<String, Set<Long>> path2ids = new HashMap<String, Set<Long>>();
        for (Map.Entry<String, Set<Watcher>> e2 : this.watchTable.entrySet()) {
            HashSet<Long> ids = new HashSet<Long>(e2.getValue().size());
            path2ids.put(e2.getKey(), ids);
            for (Watcher watcher : e2.getValue()) {
                ids.add(((ServerCnxn)watcher).getSessionId());
            }
        }
        return new WatchesPathReport(path2ids);
    }

    @Override
    public synchronized WatchesSummary getWatchesSummary() {
        int totalWatches = 0;
        for (Set<String> paths : this.watch2Paths.values()) {
            totalWatches += paths.size();
        }
        return new WatchesSummary(this.watch2Paths.size(), this.watchTable.size(), totalWatches);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public int getRecursiveWatchQty() {
        return this.watcherModeManager.getRecursiveQty();
    }

    private PathParentIterator getPathParentIterator(String path2) {
        if (this.watcherModeManager.getRecursiveQty() == 0) {
            return PathParentIterator.forPathOnly(path2);
        }
        return PathParentIterator.forAll(path2);
    }
}

