/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.channel.socket;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelException;
import io.mantisrx.shaded.org.jboss.netty.channel.DefaultServerChannelConfig;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.ServerSocketChannelConfig;
import io.mantisrx.shaded.org.jboss.netty.util.internal.ConversionUtil;
import java.net.ServerSocket;
import java.net.SocketException;

public class DefaultServerSocketChannelConfig
extends DefaultServerChannelConfig
implements ServerSocketChannelConfig {
    private final ServerSocket socket;
    private volatile int backlog;

    public DefaultServerSocketChannelConfig(ServerSocket socket) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        this.socket = socket;
    }

    public boolean setOption(String key2, Object value) {
        if (super.setOption(key2, value)) {
            return true;
        }
        if ("receiveBufferSize".equals(key2)) {
            this.setReceiveBufferSize(ConversionUtil.toInt(value));
        } else if ("reuseAddress".equals(key2)) {
            this.setReuseAddress(ConversionUtil.toBoolean(value));
        } else if ("backlog".equals(key2)) {
            this.setBacklog(ConversionUtil.toInt(value));
        } else {
            return false;
        }
        return true;
    }

    public boolean isReuseAddress() {
        try {
            return this.socket.getReuseAddress();
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public void setReuseAddress(boolean reuseAddress) {
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.socket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog < 0) {
            throw new IllegalArgumentException("backlog: " + backlog);
        }
        this.backlog = backlog;
    }
}

