/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffers;
import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLogger;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLoggerFactory;

public class WebSocketServerHandshaker00
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker00.class);

    public WebSocketServerHandshaker00(String webSocketURL, String subprotocols) {
        this(webSocketURL, subprotocols, Long.MAX_VALUE);
    }

    public WebSocketServerHandshaker00(String webSocketURL, String subprotocols, long maxFramePayloadLength) {
        super(WebSocketVersion.V00, webSocketURL, subprotocols, maxFramePayloadLength);
    }

    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 00 server handshake", channel.getId()));
        }
        if (!"Upgrade".equalsIgnoreCase(req.getHeader("Connection")) || !"WebSocket".equalsIgnoreCase(req.getHeader("Upgrade"))) {
            throw new WebSocketHandshakeException("not a WebSocket handshake request: missing upgrade");
        }
        boolean isHixie76 = req.containsHeader("Sec-WebSocket-Key1") && req.containsHeader("Sec-WebSocket-Key2");
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, isHixie76 ? "WebSocket Protocol Handshake" : "Web Socket Protocol Handshake"));
        res.addHeader("Upgrade", "WebSocket");
        res.addHeader("Connection", "Upgrade");
        if (isHixie76) {
            res.addHeader("Sec-WebSocket-Origin", req.getHeader("Origin"));
            res.addHeader("Sec-WebSocket-Location", this.getWebSocketUrl());
            String subprotocols = req.getHeader("Sec-WebSocket-Protocol");
            if (subprotocols != null) {
                String selectedSubprotocol = this.selectSubprotocol(subprotocols);
                if (selectedSubprotocol == null) {
                    throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
                }
                res.addHeader("Sec-WebSocket-Protocol", selectedSubprotocol);
                this.setSelectedSubprotocol(selectedSubprotocol);
            }
            String key1 = req.getHeader("Sec-WebSocket-Key1");
            String key2 = req.getHeader("Sec-WebSocket-Key2");
            int a = (int)(Long.parseLong(key1.replaceAll("[^0-9]", "")) / (long)key1.replaceAll("[^ ]", "").length());
            int b = (int)(Long.parseLong(key2.replaceAll("[^0-9]", "")) / (long)key2.replaceAll("[^ ]", "").length());
            long c = req.getContent().readLong();
            ChannelBuffer input = ChannelBuffers.buffer(16);
            input.writeInt(a);
            input.writeInt(b);
            input.writeLong(c);
            res.setContent(WebSocketUtil.md5(input));
        } else {
            res.addHeader("WebSocket-Origin", req.getHeader("Origin"));
            res.addHeader("WebSocket-Location", this.getWebSocketUrl());
            String protocol = req.getHeader("WebSocket-Protocol");
            if (protocol != null) {
                res.addHeader("WebSocket-Protocol", this.selectSubprotocol(protocol));
            }
        }
        ChannelFuture future2 = channel.write(res);
        future2.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future2) {
                ChannelPipeline p = future2.getChannel().getPipeline();
                if (p.get(HttpChunkAggregator.class) != null) {
                    p.remove(HttpChunkAggregator.class);
                }
                p.get(HttpRequestDecoder.class).replace("wsdecoder", new WebSocket00FrameDecoder(WebSocketServerHandshaker00.this.getMaxFramePayloadLength()));
                p.replace(HttpResponseEncoder.class, "wsencoder", (ChannelHandler)new WebSocket00FrameEncoder());
            }
        });
        return future2;
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        return channel.write(frame);
    }
}

