/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.SimpleChannelHandler;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpMessage;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyRstStreamFrame;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SpdyHttpResponseStreamIdHandler
extends SimpleChannelHandler {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new ConcurrentLinkedQueue<Integer>();

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        if (e2.getMessage() instanceof HttpMessage) {
            boolean contains = ((HttpMessage)e2.getMessage()).containsHeader("X-SPDY-Stream-ID");
            if (!contains) {
                this.ids.add(NO_ID);
            } else {
                this.ids.add(SpdyHttpHeaders.getStreamId((HttpMessage)e2.getMessage()));
            }
        } else if (e2.getMessage() instanceof SpdyRstStreamFrame) {
            this.ids.remove(((SpdyRstStreamFrame)e2.getMessage()).getStreamId());
        }
        super.messageReceived(ctx, e2);
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        if (e2.getMessage() instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)e2.getMessage();
            Integer id = this.ids.poll();
            if (id != null && id.intValue() != NO_ID.intValue() && !response.containsHeader("X-SPDY-Stream-ID")) {
                SpdyHttpHeaders.setStreamId(response, id);
            }
        }
        super.writeRequested(ctx, e2);
    }
}

