/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;

public final class OperatorDelay<T>
implements Observable.Operator<T, T> {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OperatorDelay(long delay2, TimeUnit unit, Scheduler scheduler) {
        this.delay = delay2;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        return new Subscriber<T>(child){
            boolean done;

            @Override
            public void onCompleted() {
                worker.schedule(new Action0(){

                    @Override
                    public void call() {
                        if (!done) {
                            done = true;
                            child.onCompleted();
                        }
                    }
                }, OperatorDelay.this.delay, OperatorDelay.this.unit);
            }

            @Override
            public void onError(final Throwable e2) {
                worker.schedule(new Action0(){

                    @Override
                    public void call() {
                        if (!done) {
                            done = true;
                            child.onError(e2);
                            worker.unsubscribe();
                        }
                    }
                });
            }

            @Override
            public void onNext(final T t) {
                worker.schedule(new Action0(){

                    @Override
                    public void call() {
                        if (!done) {
                            child.onNext(t);
                        }
                    }
                }, OperatorDelay.this.delay, OperatorDelay.this.unit);
            }
        };
    }
}

