/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.PropertyDetails;
import com.netflix.archaius.api.config.PollingStrategy;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.config.polling.PollingResponse;
import com.netflix.archaius.instrumentation.AccessMonitorUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingDynamicConfig
extends AbstractConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PollingDynamicConfig.class);
    private volatile Map<String, String> current = Collections.emptyMap();
    private volatile Map<String, String> currentIds = Collections.emptyMap();
    private final AtomicBoolean busy = new AtomicBoolean();
    private final Callable<PollingResponse> reader;
    private final AtomicLong updateCounter = new AtomicLong();
    private final AtomicLong errorCounter = new AtomicLong();
    private final PollingStrategy strategy;
    private volatile Instrumentation instrumentation;

    public PollingDynamicConfig(Callable<PollingResponse> reader2, PollingStrategy strategy) {
        this(reader2, strategy, null);
    }

    public PollingDynamicConfig(Callable<PollingResponse> reader2, PollingStrategy strategy, AccessMonitorUtil accessMonitorUtil) {
        this.reader = reader2;
        this.strategy = strategy;
        this.instrumentation = new Instrumentation(accessMonitorUtil, accessMonitorUtil != null);
        strategy.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PollingDynamicConfig.this.update();
                }
                catch (Exception e2) {
                    throw new RuntimeException("Failed to poll configuration", e2);
                }
            }
        });
    }

    @Override
    public boolean containsKey(String key2) {
        return this.current.containsKey(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.current.isEmpty();
    }

    @Override
    public Object getRawProperty(String key2) {
        String rawProperty = this.current.get(key2);
        if (this.instrumentationEnabled() && rawProperty != null) {
            this.recordUsage(new PropertyDetails(key2, this.currentIds.get(key2), rawProperty));
        }
        return rawProperty;
    }

    @Override
    public Object getRawPropertyUninstrumented(String key2) {
        return this.current.get(key2);
    }

    private void update() throws Exception {
        if (this.busy.compareAndSet(false, true)) {
            this.updateCounter.incrementAndGet();
            try {
                PollingResponse response = this.reader.call();
                if (response.hasData()) {
                    this.current = Collections.unmodifiableMap(response.getToAdd());
                    this.currentIds = Collections.unmodifiableMap(response.getNameToIdsMap());
                    this.notifyConfigUpdated(this);
                }
            }
            catch (Exception e2) {
                LOG.trace("Error reading data from remote server ", e2);
                this.errorCounter.incrementAndGet();
                try {
                    this.notifyError(e2, this);
                }
                catch (Exception e22) {
                    LOG.warn("Failed to notify error observer", e22);
                }
                throw e2;
            }
            finally {
                this.busy.set(false);
            }
        }
    }

    public void shutdown() {
        this.strategy.shutdown();
    }

    public long getUpdateCounter() {
        return this.updateCounter.get();
    }

    public long getErrorCounter() {
        return this.errorCounter.get();
    }

    @Override
    public Iterator<String> getKeys() {
        return this.current.keySet().iterator();
    }

    @Override
    public Iterable<String> keys() {
        return this.current.keySet();
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        boolean instrumentationEnabled = this.instrumentationEnabled();
        this.current.forEach((k, v) -> {
            if (instrumentationEnabled) {
                this.recordUsage(new PropertyDetails((String)k, this.currentIds.get(k), v));
            }
            consumer.accept((String)k, v);
        });
    }

    @Override
    public void forEachPropertyUninstrumented(BiConsumer<String, Object> consumer) {
        this.current.forEach(consumer);
    }

    @Override
    public void recordUsage(PropertyDetails propertyDetails) {
        if (this.instrumentationEnabled()) {
            if (propertyDetails.getId() == null) {
                propertyDetails = new PropertyDetails(propertyDetails.getKey(), this.currentIds.get(propertyDetails.getKey()), propertyDetails.getValue());
            }
            this.instrumentation.getAccessMonitorUtil().registerUsage(propertyDetails);
        }
    }

    @Override
    public boolean instrumentationEnabled() {
        return this.instrumentation.getEnabled() && this.instrumentation.getAccessMonitorUtil() != null;
    }

    private static class Instrumentation {
        private final AccessMonitorUtil accessMonitorUtil;
        private final boolean enabled;

        Instrumentation(AccessMonitorUtil accessMonitorUtil, boolean enabled) {
            this.accessMonitorUtil = accessMonitorUtil;
            this.enabled = enabled;
        }

        private AccessMonitorUtil getAccessMonitorUtil() {
            return this.accessMonitorUtil;
        }

        private boolean getEnabled() {
            return this.enabled;
        }
    }
}

