/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.converters;

import com.netflix.archaius.api.TypeConverter;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.ObjIntConsumer;

public final class ArrayTypeConverterFactory
implements TypeConverter.Factory {
    public static final ArrayTypeConverterFactory INSTANCE = new ArrayTypeConverterFactory();

    private ArrayTypeConverterFactory() {
    }

    @Override
    public Optional<TypeConverter<?>> get(Type type2, TypeConverter.Registry registry) {
        if (type2 instanceof Class && ((Class)type2).isArray()) {
            Class clsType = (Class)type2;
            Class<?> elementType = clsType.getComponentType();
            TypeConverter<Object> elementConverter = registry.get(elementType).orElseThrow(() -> new RuntimeException("No converter found for array element type '" + elementType + "'"));
            return Optional.of(ArrayTypeConverterFactory.create(elementConverter, clsType.getComponentType()));
        }
        return Optional.empty();
    }

    private static TypeConverter<?> create(TypeConverter<Object> elementConverter, Class<?> type2) {
        return value -> {
            ObjIntConsumer<String> elementHandler;
            if ((value = value.trim()).isEmpty()) {
                return Array.newInstance(type2, 0);
            }
            String[] elements = value.split(",");
            Object resultArray = Array.newInstance(type2, elements.length);
            if (type2.isPrimitive()) {
                if (type2.equals(Integer.TYPE)) {
                    elementHandler = (s, idx) -> Array.setInt(resultArray, idx, (Integer)elementConverter.convert((String)s));
                } else if (type2.equals(Long.TYPE)) {
                    elementHandler = (s, idx) -> Array.setLong(resultArray, idx, (Long)elementConverter.convert((String)s));
                } else if (type2.equals(Short.TYPE)) {
                    elementHandler = (s, idx) -> Array.setShort(resultArray, idx, (Short)elementConverter.convert((String)s));
                } else if (type2.equals(Byte.TYPE)) {
                    elementHandler = (s, idx) -> Array.setByte(resultArray, idx, (Byte)elementConverter.convert((String)s));
                } else if (type2.equals(Character.TYPE)) {
                    elementHandler = (s, idx) -> Array.setChar(resultArray, idx, ((Character)elementConverter.convert((String)s)).charValue());
                } else if (type2.equals(Boolean.TYPE)) {
                    elementHandler = (s, idx) -> Array.setBoolean(resultArray, idx, (Boolean)elementConverter.convert((String)s));
                } else if (type2.equals(Float.TYPE)) {
                    elementHandler = (s, idx) -> Array.setFloat(resultArray, idx, ((Float)elementConverter.convert((String)s)).floatValue());
                } else {
                    if (!type2.equals(Double.TYPE)) throw new UnsupportedOperationException("Unknown primitive type: " + type2);
                    elementHandler = (s, idx) -> Array.setDouble(resultArray, idx, (Double)elementConverter.convert((String)s));
                }
            } else {
                elementHandler = (s, idx) -> Array.set(resultArray, idx, elementConverter.convert((String)s));
            }
            for (int i = 0; i < elements.length; ++i) {
                elementHandler.accept(elements[i], i);
            }
            return resultArray;
        };
    }
}

