/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.hash;

import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.hash.AbstractHashFunction;
import io.mantisrx.shaded.com.google.common.hash.ElementTypesAreNonnullByDefault;
import io.mantisrx.shaded.com.google.common.hash.Funnel;
import io.mantisrx.shaded.com.google.common.hash.HashCode;
import io.mantisrx.shaded.com.google.common.hash.HashFunction;
import io.mantisrx.shaded.com.google.common.hash.Hasher;
import io.mantisrx.shaded.com.google.common.hash.Java8Compatibility;
import io.mantisrx.shaded.com.google.common.hash.ParametricNullness;
import io.mantisrx.shaded.com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@Immutable
@ElementTypesAreNonnullByDefault
abstract class AbstractCompositeHashFunction
extends AbstractHashFunction {
    final HashFunction[] functions;
    private static final long serialVersionUID = 0L;

    AbstractCompositeHashFunction(HashFunction ... functions) {
        for (HashFunction function : functions) {
            Preconditions.checkNotNull(function);
        }
        this.functions = functions;
    }

    abstract HashCode makeHash(Hasher[] var1);

    @Override
    public Hasher newHasher() {
        Hasher[] hashers = new Hasher[this.functions.length];
        for (int i = 0; i < hashers.length; ++i) {
            hashers[i] = this.functions[i].newHasher();
        }
        return this.fromHashers(hashers);
    }

    @Override
    public Hasher newHasher(int expectedInputSize) {
        Preconditions.checkArgument(expectedInputSize >= 0);
        Hasher[] hashers = new Hasher[this.functions.length];
        for (int i = 0; i < hashers.length; ++i) {
            hashers[i] = this.functions[i].newHasher(expectedInputSize);
        }
        return this.fromHashers(hashers);
    }

    private Hasher fromHashers(final Hasher[] hashers) {
        return new Hasher(){

            @Override
            public Hasher putByte(byte b) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putByte(b);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes2) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putBytes(bytes2);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes2, int off, int len) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putBytes(bytes2, off, len);
                }
                return this;
            }

            @Override
            public Hasher putBytes(ByteBuffer bytes2) {
                int pos = bytes2.position();
                for (Hasher hasher2 : hashers) {
                    Java8Compatibility.position(bytes2, pos);
                    hasher2.putBytes(bytes2);
                }
                return this;
            }

            @Override
            public Hasher putShort(short s) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putShort(s);
                }
                return this;
            }

            @Override
            public Hasher putInt(int i) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putInt(i);
                }
                return this;
            }

            @Override
            public Hasher putLong(long l) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putLong(l);
                }
                return this;
            }

            @Override
            public Hasher putFloat(float f) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putFloat(f);
                }
                return this;
            }

            @Override
            public Hasher putDouble(double d) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putDouble(d);
                }
                return this;
            }

            @Override
            public Hasher putBoolean(boolean b) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putBoolean(b);
                }
                return this;
            }

            @Override
            public Hasher putChar(char c) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putChar(c);
                }
                return this;
            }

            @Override
            public Hasher putUnencodedChars(CharSequence chars2) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putUnencodedChars(chars2);
                }
                return this;
            }

            @Override
            public Hasher putString(CharSequence chars2, Charset charset) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putString(chars2, charset);
                }
                return this;
            }

            @Override
            public <T> Hasher putObject(@ParametricNullness T instance, Funnel<? super T> funnel) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putObject(instance, funnel);
                }
                return this;
            }

            @Override
            public HashCode hash() {
                return AbstractCompositeHashFunction.this.makeHash(hashers);
            }
        };
    }
}

