/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.resolver.dns;

import io.mantisrx.shaded.io.netty.bootstrap.Bootstrap;
import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.buffer.Unpooled;
import io.mantisrx.shaded.io.netty.channel.AddressedEnvelope;
import io.mantisrx.shaded.io.netty.channel.Channel;
import io.mantisrx.shaded.io.netty.channel.ChannelFactory;
import io.mantisrx.shaded.io.netty.channel.ChannelFuture;
import io.mantisrx.shaded.io.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.mantisrx.shaded.io.netty.channel.ChannelInitializer;
import io.mantisrx.shaded.io.netty.channel.ChannelOption;
import io.mantisrx.shaded.io.netty.channel.ChannelPromise;
import io.mantisrx.shaded.io.netty.channel.EventLoop;
import io.mantisrx.shaded.io.netty.channel.FixedRecvByteBufAllocator;
import io.mantisrx.shaded.io.netty.channel.socket.DatagramChannel;
import io.mantisrx.shaded.io.netty.channel.socket.InternetProtocolFamily;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DatagramDnsResponse;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsQuestion;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsRawRecord;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsRecord;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsRecordType;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsResponse;
import io.mantisrx.shaded.io.netty.resolver.HostsFileEntriesResolver;
import io.mantisrx.shaded.io.netty.resolver.InetNameResolver;
import io.mantisrx.shaded.io.netty.resolver.ResolvedAddressTypes;
import io.mantisrx.shaded.io.netty.resolver.dns.AuthoritativeDnsServerCache;
import io.mantisrx.shaded.io.netty.resolver.dns.AuthoritativeDnsServerCacheAdapter;
import io.mantisrx.shaded.io.netty.resolver.dns.BiDnsQueryLifecycleObserverFactory;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsAddressResolveContext;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsCache;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsCacheEntry;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsCnameCache;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsNameResolverException;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsQueryContext;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsQueryContextManager;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsRecordResolveContext;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsServerAddressStream;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.mantisrx.shaded.io.netty.resolver.dns.NameServerComparator;
import io.mantisrx.shaded.io.netty.resolver.dns.NoopDnsCnameCache;
import io.mantisrx.shaded.io.netty.resolver.dns.NoopDnsQueryLifecycleObserverFactory;
import io.mantisrx.shaded.io.netty.resolver.dns.SequentialDnsServerAddressStream;
import io.mantisrx.shaded.io.netty.resolver.dns.TraceDnsQueryLifeCycleObserverFactory;
import io.mantisrx.shaded.io.netty.resolver.dns.UnixResolverDnsServerAddressStreamProvider;
import io.mantisrx.shaded.io.netty.util.NetUtil;
import io.mantisrx.shaded.io.netty.util.ReferenceCountUtil;
import io.mantisrx.shaded.io.netty.util.concurrent.FastThreadLocal;
import io.mantisrx.shaded.io.netty.util.concurrent.Future;
import io.mantisrx.shaded.io.netty.util.concurrent.FutureListener;
import io.mantisrx.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.mantisrx.shaded.io.netty.util.concurrent.Promise;
import io.mantisrx.shaded.io.netty.util.internal.EmptyArrays;
import io.mantisrx.shaded.io.netty.util.internal.ObjectUtil;
import io.mantisrx.shaded.io.netty.util.internal.PlatformDependent;
import io.mantisrx.shaded.io.netty.util.internal.StringUtil;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLogger;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class DnsNameResolver
extends InetNameResolver {
    private static final InternalLogger logger;
    private static final String LOCALHOST = "localhost";
    private static final InetAddress LOCALHOST_ADDRESS;
    private static final DnsRecord[] EMPTY_ADDITIONALS;
    private static final DnsRecordType[] IPV4_ONLY_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES;
    private static final DnsRecordType[] IPV4_PREFERRED_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
    private static final DnsRecordType[] IPV6_ONLY_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES;
    private static final DnsRecordType[] IPV6_PREFERRED_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
    static final ResolvedAddressTypes DEFAULT_RESOLVE_ADDRESS_TYPES;
    static final String[] DEFAULT_SEARCH_DOMAINS;
    private static final int DEFAULT_NDOTS;
    private static final DatagramDnsResponseDecoder DECODER;
    private static final DatagramDnsQueryEncoder ENCODER;
    final Future<Channel> channelFuture;
    final Channel ch;
    private final Comparator<InetSocketAddress> nameServerComparator;
    final DnsQueryContextManager queryContextManager = new DnsQueryContextManager();
    private final DnsCache resolveCache;
    private final AuthoritativeDnsServerCache authoritativeDnsServerCache;
    private final DnsCnameCache cnameCache;
    private final FastThreadLocal<DnsServerAddressStream> nameServerAddrStream = new FastThreadLocal<DnsServerAddressStream>(){

        @Override
        protected DnsServerAddressStream initialValue() {
            return DnsNameResolver.this.dnsServerAddressStreamProvider.nameServerAddressStream("");
        }
    };
    private final long queryTimeoutMillis;
    private final int maxQueriesPerResolve;
    private final ResolvedAddressTypes resolvedAddressTypes;
    private final InternetProtocolFamily[] resolvedInternetProtocolFamilies;
    private final boolean recursionDesired;
    private final int maxPayloadSize;
    private final boolean optResourceEnabled;
    private final HostsFileEntriesResolver hostsFileEntriesResolver;
    private final DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    private final String[] searchDomains;
    private final int ndots;
    private final boolean supportsAAAARecords;
    private final boolean supportsARecords;
    private final InternetProtocolFamily preferredAddressType;
    private final DnsRecordType[] resolveRecordTypes;
    private final boolean decodeIdn;
    private final DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory;

    private static List<String> getSearchDomainsHack() throws Exception {
        Class<?> configClass = Class.forName("sun.net.dns.ResolverConfiguration");
        Method open = configClass.getMethod("open", new Class[0]);
        Method nameservers = configClass.getMethod("searchlist", new Class[0]);
        Object instance = open.invoke(null, new Object[0]);
        return (List)nameservers.invoke(instance, new Object[0]);
    }

    @Deprecated
    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsCache resolveCache, DnsCache authoritativeDnsServerCache, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, boolean traceEnabled, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String[] searchDomains, int ndots, boolean decodeIdn) {
        this(eventLoop, channelFactory, resolveCache, new AuthoritativeDnsServerCacheAdapter(authoritativeDnsServerCache), dnsQueryLifecycleObserverFactory, queryTimeoutMillis, resolvedAddressTypes, recursionDesired, maxQueriesPerResolve, traceEnabled, maxPayloadSize, optResourceEnabled, hostsFileEntriesResolver, dnsServerAddressStreamProvider, searchDomains, ndots, decodeIdn);
    }

    @Deprecated
    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsCache resolveCache, AuthoritativeDnsServerCache authoritativeDnsServerCache, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, boolean traceEnabled, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String[] searchDomains, int ndots, boolean decodeIdn) {
        this(eventLoop, channelFactory, resolveCache, NoopDnsCnameCache.INSTANCE, authoritativeDnsServerCache, dnsQueryLifecycleObserverFactory, queryTimeoutMillis, resolvedAddressTypes, recursionDesired, maxQueriesPerResolve, traceEnabled, maxPayloadSize, optResourceEnabled, hostsFileEntriesResolver, dnsServerAddressStreamProvider, searchDomains, ndots, decodeIdn);
    }

    DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, final DnsCache resolveCache, final DnsCnameCache cnameCache, final AuthoritativeDnsServerCache authoritativeDnsServerCache, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, boolean traceEnabled, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String[] searchDomains, int ndots, boolean decodeIdn) {
        super(eventLoop);
        this.queryTimeoutMillis = ObjectUtil.checkPositive(queryTimeoutMillis, "queryTimeoutMillis");
        this.resolvedAddressTypes = resolvedAddressTypes != null ? resolvedAddressTypes : DEFAULT_RESOLVE_ADDRESS_TYPES;
        this.recursionDesired = recursionDesired;
        this.maxQueriesPerResolve = ObjectUtil.checkPositive(maxQueriesPerResolve, "maxQueriesPerResolve");
        this.maxPayloadSize = ObjectUtil.checkPositive(maxPayloadSize, "maxPayloadSize");
        this.optResourceEnabled = optResourceEnabled;
        this.hostsFileEntriesResolver = ObjectUtil.checkNotNull(hostsFileEntriesResolver, "hostsFileEntriesResolver");
        this.dnsServerAddressStreamProvider = ObjectUtil.checkNotNull(dnsServerAddressStreamProvider, "dnsServerAddressStreamProvider");
        this.resolveCache = ObjectUtil.checkNotNull(resolveCache, "resolveCache");
        this.cnameCache = ObjectUtil.checkNotNull(cnameCache, "cnameCache");
        this.dnsQueryLifecycleObserverFactory = traceEnabled ? (dnsQueryLifecycleObserverFactory instanceof NoopDnsQueryLifecycleObserverFactory ? new TraceDnsQueryLifeCycleObserverFactory() : new BiDnsQueryLifecycleObserverFactory(new TraceDnsQueryLifeCycleObserverFactory(), dnsQueryLifecycleObserverFactory)) : ObjectUtil.checkNotNull(dnsQueryLifecycleObserverFactory, "dnsQueryLifecycleObserverFactory");
        this.searchDomains = searchDomains != null ? (String[])searchDomains.clone() : DEFAULT_SEARCH_DOMAINS;
        this.ndots = ndots >= 0 ? ndots : DEFAULT_NDOTS;
        this.decodeIdn = decodeIdn;
        switch (this.resolvedAddressTypes) {
            case IPV4_ONLY: {
                this.supportsAAAARecords = false;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV4_ONLY_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            case IPV4_PREFERRED: {
                this.supportsAAAARecords = true;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV4_PREFERRED_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            case IPV6_ONLY: {
                this.supportsAAAARecords = true;
                this.supportsARecords = false;
                this.resolveRecordTypes = IPV6_ONLY_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            case IPV6_PREFERRED: {
                this.supportsAAAARecords = true;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV6_PREFERRED_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
            }
        }
        this.preferredAddressType = DnsNameResolver.preferredAddressType(this.resolvedAddressTypes);
        this.authoritativeDnsServerCache = ObjectUtil.checkNotNull(authoritativeDnsServerCache, "authoritativeDnsServerCache");
        this.nameServerComparator = new NameServerComparator(this.preferredAddressType.addressType());
        Bootstrap b = new Bootstrap();
        b.group(this.executor());
        b.channelFactory(channelFactory);
        b.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, true);
        final DnsResponseHandler responseHandler = new DnsResponseHandler(this.executor().newPromise());
        b.handler(new ChannelInitializer<DatagramChannel>(){

            @Override
            protected void initChannel(DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(DECODER, ENCODER, responseHandler);
            }
        });
        this.channelFuture = responseHandler.channelActivePromise;
        ChannelFuture future2 = b.register();
        Throwable cause = future2.cause();
        if (cause != null) {
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalStateException("Unable to create / register Channel", cause);
        }
        this.ch = future2.channel();
        this.ch.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(maxPayloadSize));
        this.ch.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future2) {
                resolveCache.clear();
                cnameCache.clear();
                authoritativeDnsServerCache.clear();
            }
        });
    }

    static InternetProtocolFamily preferredAddressType(ResolvedAddressTypes resolvedAddressTypes) {
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: 
            case IPV4_PREFERRED: {
                return InternetProtocolFamily.IPv4;
            }
            case IPV6_ONLY: 
            case IPV6_PREFERRED: {
                return InternetProtocolFamily.IPv6;
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
    }

    InetSocketAddress newRedirectServerAddress(InetAddress server2) {
        return new InetSocketAddress(server2, 53);
    }

    final DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory() {
        return this.dnsQueryLifecycleObserverFactory;
    }

    protected DnsServerAddressStream newRedirectDnsServerStream(String hostname, List<InetSocketAddress> nameservers) {
        DnsServerAddressStream cached = this.authoritativeDnsServerCache().get(hostname);
        if (cached == null || cached.size() == 0) {
            Collections.sort(nameservers, this.nameServerComparator);
            return new SequentialDnsServerAddressStream(nameservers, 0);
        }
        return cached;
    }

    public DnsCache resolveCache() {
        return this.resolveCache;
    }

    DnsCnameCache cnameCache() {
        return this.cnameCache;
    }

    public AuthoritativeDnsServerCache authoritativeDnsServerCache() {
        return this.authoritativeDnsServerCache;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public ResolvedAddressTypes resolvedAddressTypes() {
        return this.resolvedAddressTypes;
    }

    InternetProtocolFamily[] resolvedInternetProtocolFamiliesUnsafe() {
        return this.resolvedInternetProtocolFamilies;
    }

    final String[] searchDomains() {
        return this.searchDomains;
    }

    final int ndots() {
        return this.ndots;
    }

    final boolean supportsAAAARecords() {
        return this.supportsAAAARecords;
    }

    final boolean supportsARecords() {
        return this.supportsARecords;
    }

    final InternetProtocolFamily preferredAddressType() {
        return this.preferredAddressType;
    }

    final DnsRecordType[] resolveRecordTypes() {
        return this.resolveRecordTypes;
    }

    final boolean isDecodeIdn() {
        return this.decodeIdn;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean isOptResourceEnabled() {
        return this.optResourceEnabled;
    }

    public HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    @Override
    public void close() {
        if (this.ch.isOpen()) {
            this.ch.close();
        }
    }

    @Override
    protected EventLoop executor() {
        return (EventLoop)super.executor();
    }

    private InetAddress resolveHostsFileEntry(String hostname) {
        if (this.hostsFileEntriesResolver == null) {
            return null;
        }
        InetAddress address = this.hostsFileEntriesResolver.address(hostname, this.resolvedAddressTypes);
        if (address == null && PlatformDependent.isWindows() && LOCALHOST.equalsIgnoreCase(hostname)) {
            return LOCALHOST_ADDRESS;
        }
        return address;
    }

    @Override
    public final Future<InetAddress> resolve(String inetHost, Iterable<DnsRecord> additionals) {
        return this.resolve(inetHost, additionals, this.executor().newPromise());
    }

    public final Future<InetAddress> resolve(String inetHost, Iterable<DnsRecord> additionals, Promise<InetAddress> promise2) {
        ObjectUtil.checkNotNull(promise2, "promise");
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        try {
            this.doResolve(inetHost, additionalsArray, promise2, this.resolveCache);
            return promise2;
        }
        catch (Exception e2) {
            return promise2.setFailure(e2);
        }
    }

    public final Future<List<InetAddress>> resolveAll(String inetHost, Iterable<DnsRecord> additionals) {
        return this.resolveAll(inetHost, additionals, this.executor().newPromise());
    }

    public final Future<List<InetAddress>> resolveAll(String inetHost, Iterable<DnsRecord> additionals, Promise<List<InetAddress>> promise2) {
        ObjectUtil.checkNotNull(promise2, "promise");
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        try {
            this.doResolveAll(inetHost, additionalsArray, promise2, this.resolveCache);
            return promise2;
        }
        catch (Exception e2) {
            return promise2.setFailure(e2);
        }
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise2) throws Exception {
        this.doResolve(inetHost, EMPTY_ADDITIONALS, promise2, this.resolveCache);
    }

    public final Future<List<DnsRecord>> resolveAll(DnsQuestion question) {
        return this.resolveAll(question, EMPTY_ADDITIONALS, this.executor().newPromise());
    }

    public final Future<List<DnsRecord>> resolveAll(DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.resolveAll(question, additionals, this.executor().newPromise());
    }

    public final Future<List<DnsRecord>> resolveAll(DnsQuestion question, Iterable<DnsRecord> additionals, Promise<List<DnsRecord>> promise2) {
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        return this.resolveAll(question, additionalsArray, promise2);
    }

    private Future<List<DnsRecord>> resolveAll(DnsQuestion question, DnsRecord[] additionals, Promise<List<DnsRecord>> promise2) {
        InetAddress hostsFileEntry;
        ObjectUtil.checkNotNull(question, "question");
        ObjectUtil.checkNotNull(promise2, "promise");
        DnsRecordType type2 = question.type();
        String hostname = question.name();
        if ((type2 == DnsRecordType.A || type2 == DnsRecordType.AAAA) && (hostsFileEntry = this.resolveHostsFileEntry(hostname)) != null) {
            ByteBuf content = null;
            if (hostsFileEntry instanceof Inet4Address) {
                if (type2 == DnsRecordType.A) {
                    content = Unpooled.wrappedBuffer(hostsFileEntry.getAddress());
                }
            } else if (hostsFileEntry instanceof Inet6Address && type2 == DnsRecordType.AAAA) {
                content = Unpooled.wrappedBuffer(hostsFileEntry.getAddress());
            }
            if (content != null) {
                DnsNameResolver.trySuccess(promise2, Collections.singletonList(new DefaultDnsRawRecord(hostname, type2, 86400L, content)));
                return promise2;
            }
        }
        DnsServerAddressStream nameServerAddrs = this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
        new DnsRecordResolveContext(this, question, additionals, nameServerAddrs).resolve(promise2);
        return promise2;
    }

    private static DnsRecord[] toArray(Iterable<DnsRecord> additionals, boolean validateType) {
        ObjectUtil.checkNotNull(additionals, "additionals");
        if (additionals instanceof Collection) {
            Collection records = (Collection)additionals;
            for (DnsRecord r : additionals) {
                DnsNameResolver.validateAdditional(r, validateType);
            }
            return records.toArray(new DnsRecord[records.size()]);
        }
        Iterator<DnsRecord> additionalsIt = additionals.iterator();
        if (!additionalsIt.hasNext()) {
            return EMPTY_ADDITIONALS;
        }
        ArrayList<DnsRecord> records = new ArrayList<DnsRecord>();
        do {
            DnsRecord r = additionalsIt.next();
            DnsNameResolver.validateAdditional(r, validateType);
            records.add(r);
        } while (additionalsIt.hasNext());
        return records.toArray(new DnsRecord[records.size()]);
    }

    private static void validateAdditional(DnsRecord record, boolean validateType) {
        ObjectUtil.checkNotNull(record, "record");
        if (validateType && record instanceof DnsRawRecord) {
            throw new IllegalArgumentException("DnsRawRecord implementations not allowed: " + record);
        }
    }

    private InetAddress loopbackAddress() {
        return this.preferredAddressType().localhost();
    }

    protected void doResolve(String inetHost, DnsRecord[] additionals, Promise<InetAddress> promise2, DnsCache resolveCache) throws Exception {
        if (inetHost == null || inetHost.isEmpty()) {
            promise2.setSuccess(this.loopbackAddress());
            return;
        }
        byte[] bytes2 = NetUtil.createByteArrayFromIpAddressString(inetHost);
        if (bytes2 != null) {
            promise2.setSuccess(InetAddress.getByAddress(bytes2));
            return;
        }
        String hostname = DnsNameResolver.hostname(inetHost);
        InetAddress hostsFileEntry = this.resolveHostsFileEntry(hostname);
        if (hostsFileEntry != null) {
            promise2.setSuccess(hostsFileEntry);
            return;
        }
        if (!this.doResolveCached(hostname, additionals, promise2, resolveCache)) {
            this.doResolveUncached(hostname, additionals, promise2, resolveCache);
        }
    }

    private boolean doResolveCached(String hostname, DnsRecord[] additionals, Promise<InetAddress> promise2, DnsCache resolveCache) {
        List<? extends DnsCacheEntry> cachedEntries = resolveCache.get(hostname, additionals);
        if (cachedEntries == null || cachedEntries.isEmpty()) {
            return false;
        }
        Throwable cause = cachedEntries.get(0).cause();
        if (cause == null) {
            int numEntries = cachedEntries.size();
            for (InternetProtocolFamily f : this.resolvedInternetProtocolFamilies) {
                for (int i = 0; i < numEntries; ++i) {
                    DnsCacheEntry e2 = cachedEntries.get(i);
                    if (!f.addressType().isInstance(e2.address())) continue;
                    DnsNameResolver.trySuccess(promise2, e2.address());
                    return true;
                }
            }
            return false;
        }
        DnsNameResolver.tryFailure(promise2, cause);
        return true;
    }

    static <T> void trySuccess(Promise<T> promise2, T result) {
        if (!promise2.trySuccess(result)) {
            logger.warn("Failed to notify success ({}) to a promise: {}", (Object)result, (Object)promise2);
        }
    }

    private static void tryFailure(Promise<?> promise2, Throwable cause) {
        if (!promise2.tryFailure(cause)) {
            logger.warn("Failed to notify failure to a promise: {}", (Object)promise2, (Object)cause);
        }
    }

    private void doResolveUncached(String hostname, DnsRecord[] additionals, final Promise<InetAddress> promise2, DnsCache resolveCache) {
        Promise<List<InetAddress>> allPromise = this.executor().newPromise();
        this.doResolveAllUncached(hostname, additionals, allPromise, resolveCache);
        allPromise.addListener((GenericFutureListener<Future<List<InetAddress>>>)new FutureListener<List<InetAddress>>(){

            @Override
            public void operationComplete(Future<List<InetAddress>> future2) {
                if (future2.isSuccess()) {
                    DnsNameResolver.trySuccess(promise2, future2.getNow().get(0));
                } else {
                    DnsNameResolver.tryFailure(promise2, future2.cause());
                }
            }
        });
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise2) throws Exception {
        this.doResolveAll(inetHost, EMPTY_ADDITIONALS, promise2, this.resolveCache);
    }

    protected void doResolveAll(String inetHost, DnsRecord[] additionals, Promise<List<InetAddress>> promise2, DnsCache resolveCache) throws Exception {
        if (inetHost == null || inetHost.isEmpty()) {
            promise2.setSuccess(Collections.singletonList(this.loopbackAddress()));
            return;
        }
        byte[] bytes2 = NetUtil.createByteArrayFromIpAddressString(inetHost);
        if (bytes2 != null) {
            promise2.setSuccess(Collections.singletonList(InetAddress.getByAddress(bytes2)));
            return;
        }
        String hostname = DnsNameResolver.hostname(inetHost);
        InetAddress hostsFileEntry = this.resolveHostsFileEntry(hostname);
        if (hostsFileEntry != null) {
            promise2.setSuccess(Collections.singletonList(hostsFileEntry));
            return;
        }
        if (!DnsNameResolver.doResolveAllCached(hostname, additionals, promise2, resolveCache, this.resolvedInternetProtocolFamilies)) {
            this.doResolveAllUncached(hostname, additionals, promise2, resolveCache);
        }
    }

    static boolean doResolveAllCached(String hostname, DnsRecord[] additionals, Promise<List<InetAddress>> promise2, DnsCache resolveCache, InternetProtocolFamily[] resolvedInternetProtocolFamilies) {
        List<? extends DnsCacheEntry> cachedEntries = resolveCache.get(hostname, additionals);
        if (cachedEntries == null || cachedEntries.isEmpty()) {
            return false;
        }
        Throwable cause = cachedEntries.get(0).cause();
        if (cause == null) {
            ArrayList<InetAddress> result = null;
            int numEntries = cachedEntries.size();
            for (InternetProtocolFamily f : resolvedInternetProtocolFamilies) {
                for (int i = 0; i < numEntries; ++i) {
                    DnsCacheEntry e2 = cachedEntries.get(i);
                    if (!f.addressType().isInstance(e2.address())) continue;
                    if (result == null) {
                        result = new ArrayList<InetAddress>(numEntries);
                    }
                    result.add(e2.address());
                }
            }
            if (result != null) {
                DnsNameResolver.trySuccess(promise2, result);
                return true;
            }
            return false;
        }
        DnsNameResolver.tryFailure(promise2, cause);
        return true;
    }

    private void doResolveAllUncached(final String hostname, final DnsRecord[] additionals, final Promise<List<InetAddress>> promise2, final DnsCache resolveCache) {
        EventLoop executor = this.executor();
        if (executor.inEventLoop()) {
            this.doResolveAllUncached0(hostname, additionals, promise2, resolveCache);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DnsNameResolver.this.doResolveAllUncached0(hostname, additionals, promise2, resolveCache);
                }
            });
        }
    }

    private void doResolveAllUncached0(String hostname, DnsRecord[] additionals, Promise<List<InetAddress>> promise2, DnsCache resolveCache) {
        assert (this.executor().inEventLoop());
        DnsServerAddressStream nameServerAddrs = this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
        new DnsAddressResolveContext(this, hostname, additionals, nameServerAddrs, resolveCache, this.authoritativeDnsServerCache).resolve(promise2);
    }

    private static String hostname(String inetHost) {
        String hostname = IDN.toASCII(inetHost);
        if (StringUtil.endsWith(inetHost, '.') && !StringUtil.endsWith(hostname, '.')) {
            hostname = hostname + ".";
        }
        return hostname;
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question) {
        return this.query(this.nextNameServerAddress(), question);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.query(this.nextNameServerAddress(), question, additionals);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise2) {
        return this.query(this.nextNameServerAddress(), question, Collections.<DnsRecord>emptyList(), promise2);
    }

    private InetSocketAddress nextNameServerAddress() {
        return this.nameServerAddrStream.get().next();
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question) {
        return this.query0(nameServerAddr, question, EMPTY_ADDITIONALS, true, this.ch.newPromise(), this.ch.eventLoop().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.query0(nameServerAddr, question, DnsNameResolver.toArray(additionals, false), true, this.ch.newPromise(), this.ch.eventLoop().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise2) {
        return this.query0(nameServerAddr, question, EMPTY_ADDITIONALS, true, this.ch.newPromise(), promise2);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Iterable<DnsRecord> additionals, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise2) {
        return this.query0(nameServerAddr, question, DnsNameResolver.toArray(additionals, false), true, this.ch.newPromise(), promise2);
    }

    public static boolean isTransportOrTimeoutError(Throwable cause) {
        return cause != null && cause.getCause() instanceof DnsNameResolverException;
    }

    public static boolean isTimeoutError(Throwable cause) {
        return cause != null && cause.getCause() instanceof DnsNameResolverTimeoutException;
    }

    final void flushQueries() {
        this.ch.flush();
    }

    final Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query0(InetSocketAddress nameServerAddr, DnsQuestion question, DnsRecord[] additionals, boolean flush2, ChannelPromise writePromise, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise2) {
        assert (!writePromise.isVoid());
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> castPromise = DnsNameResolver.cast(ObjectUtil.checkNotNull(promise2, "promise"));
        try {
            new DnsQueryContext(this, nameServerAddr, question, additionals, castPromise).query(flush2, writePromise);
            return castPromise;
        }
        catch (Exception e2) {
            return castPromise.setFailure(e2);
        }
    }

    private static Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> cast(Promise<?> promise2) {
        return promise2;
    }

    final DnsServerAddressStream newNameServerAddressStream(String hostname) {
        return this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
    }

    static {
        int ndots;
        String[] searchDomains;
        logger = InternalLoggerFactory.getInstance(DnsNameResolver.class);
        EMPTY_ADDITIONALS = new DnsRecord[0];
        IPV4_ONLY_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.A};
        IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv4};
        IPV4_PREFERRED_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.A, DnsRecordType.AAAA};
        IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv4, InternetProtocolFamily.IPv6};
        IPV6_ONLY_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.AAAA};
        IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv6};
        IPV6_PREFERRED_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.AAAA, DnsRecordType.A};
        IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv6, InternetProtocolFamily.IPv4};
        if (NetUtil.isIpV4StackPreferred()) {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV4_ONLY;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
        } else if (NetUtil.isIpV6AddressesPreferred()) {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV6_PREFERRED;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST6;
        } else {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV4_PREFERRED;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
        }
        try {
            List<String> list = PlatformDependent.isWindows() ? DnsNameResolver.getSearchDomainsHack() : UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains();
            searchDomains = list.toArray(new String[0]);
        }
        catch (Exception ignore) {
            searchDomains = EmptyArrays.EMPTY_STRINGS;
        }
        DEFAULT_SEARCH_DOMAINS = searchDomains;
        try {
            ndots = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverFirstNdots();
        }
        catch (Exception ignore) {
            ndots = 1;
        }
        DEFAULT_NDOTS = ndots;
        DECODER = new DatagramDnsResponseDecoder();
        ENCODER = new DatagramDnsQueryEncoder();
    }

    private final class DnsResponseHandler
    extends ChannelInboundHandlerAdapter {
        private final Promise<Channel> channelActivePromise;

        DnsResponseHandler(Promise<Channel> channelActivePromise) {
            this.channelActivePromise = channelActivePromise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            try {
                DnsQueryContext qCtx;
                DatagramDnsResponse res = (DatagramDnsResponse)msg;
                int queryId = res.id();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} RECEIVED: [{}: {}], {}", DnsNameResolver.this.ch, queryId, res.sender(), res);
                }
                if ((qCtx = DnsNameResolver.this.queryContextManager.get(res.sender(), queryId)) == null) {
                    logger.warn("{} Received a DNS response with an unknown ID: {}", (Object)DnsNameResolver.this.ch, (Object)queryId);
                    return;
                }
                qCtx.finish(res);
            }
            finally {
                ReferenceCountUtil.safeRelease(msg);
            }
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            this.channelActivePromise.setSuccess(ctx.channel());
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.warn("{} Unexpected exception: ", (Object)DnsNameResolver.this.ch, (Object)cause);
        }
    }
}

