/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.jline;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class ANSIBuffer {
    private boolean ansiEnabled = true;
    private final StringBuffer ansiBuffer = new StringBuffer();
    private final StringBuffer plainBuffer = new StringBuffer();

    public ANSIBuffer() {
    }

    public ANSIBuffer(String str2) {
        this.append(str2);
    }

    public void setAnsiEnabled(boolean ansi) {
        this.ansiEnabled = ansi;
    }

    public boolean getAnsiEnabled() {
        return this.ansiEnabled;
    }

    public String getAnsiBuffer() {
        return this.ansiBuffer.toString();
    }

    public String getPlainBuffer() {
        return this.plainBuffer.toString();
    }

    public String toString(boolean ansi) {
        return ansi ? this.getAnsiBuffer() : this.getPlainBuffer();
    }

    public String toString() {
        return this.toString(this.ansiEnabled);
    }

    public ANSIBuffer append(String str2) {
        this.ansiBuffer.append(str2);
        this.plainBuffer.append(str2);
        return this;
    }

    public ANSIBuffer attrib(String str2, int code) {
        this.ansiBuffer.append(ANSICodes.attrib(code)).append(str2).append(ANSICodes.attrib(0));
        this.plainBuffer.append(str2);
        return this;
    }

    public ANSIBuffer red(String str2) {
        return this.attrib(str2, 31);
    }

    public ANSIBuffer blue(String str2) {
        return this.attrib(str2, 34);
    }

    public ANSIBuffer green(String str2) {
        return this.attrib(str2, 32);
    }

    public ANSIBuffer black(String str2) {
        return this.attrib(str2, 30);
    }

    public ANSIBuffer yellow(String str2) {
        return this.attrib(str2, 33);
    }

    public ANSIBuffer magenta(String str2) {
        return this.attrib(str2, 35);
    }

    public ANSIBuffer cyan(String str2) {
        return this.attrib(str2, 36);
    }

    public ANSIBuffer bold(String str2) {
        return this.attrib(str2, 1);
    }

    public ANSIBuffer underscore(String str2) {
        return this.attrib(str2, 4);
    }

    public ANSIBuffer blink(String str2) {
        return this.attrib(str2, 5);
    }

    public ANSIBuffer reverse(String str2) {
        return this.attrib(str2, 7);
    }

    public static void main(String[] args) throws Exception {
        String line;
        BufferedReader reader2 = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(ANSICodes.setkey("97", "97;98;99;13") + ANSICodes.attrib(0));
        System.out.flush();
        while ((line = reader2.readLine()) != null) {
            System.out.println("GOT: " + line);
        }
    }

    public static class ANSICodes {
        static final int OFF = 0;
        static final int BOLD = 1;
        static final int UNDERSCORE = 4;
        static final int BLINK = 5;
        static final int REVERSE = 7;
        static final int CONCEALED = 8;
        static final int FG_BLACK = 30;
        static final int FG_RED = 31;
        static final int FG_GREEN = 32;
        static final int FG_YELLOW = 33;
        static final int FG_BLUE = 34;
        static final int FG_MAGENTA = 35;
        static final int FG_CYAN = 36;
        static final int FG_WHITE = 37;
        static final char ESC = '\u001b';

        private ANSICodes() {
        }

        public static String setmode(int mode) {
            return "\u001b[=" + mode + "h";
        }

        public static String resetmode(int mode) {
            return "\u001b[=" + mode + "l";
        }

        public static String clrscr() {
            return "\u001b[2J";
        }

        public static String clreol() {
            return "\u001b[K";
        }

        public static String left(int n) {
            return "\u001b[" + n + "D";
        }

        public static String right(int n) {
            return "\u001b[" + n + "C";
        }

        public static String up(int n) {
            return "\u001b[" + n + "A";
        }

        public static String down(int n) {
            return "\u001b[" + n + "B";
        }

        public static String gotoxy(int row, int column) {
            return "\u001b[" + row + ";" + column + "H";
        }

        public static String save() {
            return "\u001b[s";
        }

        public static String restore() {
            return "\u001b[u";
        }

        public static String attrib(int attr) {
            return "\u001b[" + attr + "m";
        }

        public static String setkey(String code, String value) {
            return "\u001b[" + code + ";" + value + "p";
        }
    }
}

