/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import java.util.concurrent.atomic.AtomicBoolean;

public class EnsureContainers {
    private final CuratorFramework client;
    private final String path;
    private final AtomicBoolean ensureNeeded = new AtomicBoolean(true);

    public EnsureContainers(CuratorFramework client, String path2) {
        this.client = client;
        this.path = path2;
    }

    public void ensure() throws Exception {
        if (this.ensureNeeded.get()) {
            this.internalEnsure();
        }
    }

    public void reset() {
        this.ensureNeeded.set(true);
    }

    private synchronized void internalEnsure() throws Exception {
        if (this.ensureNeeded.compareAndSet(true, false)) {
            this.client.createContainers(this.path);
        }
    }
}

