/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.imps;

import io.mantisrx.shaded.org.apache.curator.RetryLoop;
import io.mantisrx.shaded.org.apache.curator.drivers.OperationTrace;
import io.mantisrx.shaded.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.ACLCreateModeBackgroundPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.ACLCreateModePathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.ACLCreateModeStatBackgroundPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.ACLPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundCallback;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.CreateBackgroundModeACLable;
import io.mantisrx.shaded.org.apache.curator.framework.api.CreateBackgroundModeStatACLable;
import io.mantisrx.shaded.org.apache.curator.framework.api.CreateBuilder;
import io.mantisrx.shaded.org.apache.curator.framework.api.CreateBuilder2;
import io.mantisrx.shaded.org.apache.curator.framework.api.CreateBuilderMain;
import io.mantisrx.shaded.org.apache.curator.framework.api.CreateProtectACLCreateModePathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.CuratorEventType;
import io.mantisrx.shaded.org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.PathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.ProtectACLCreateModePathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.ProtectACLCreateModeStatPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.UnhandledErrorListener;
import io.mantisrx.shaded.org.apache.curator.framework.api.transaction.OperationType;
import io.mantisrx.shaded.org.apache.curator.framework.api.transaction.TransactionCreateBuilder;
import io.mantisrx.shaded.org.apache.curator.framework.api.transaction.TransactionCreateBuilder2;
import io.mantisrx.shaded.org.apache.curator.framework.imps.ACLing;
import io.mantisrx.shaded.org.apache.curator.framework.imps.BackgroundOperation;
import io.mantisrx.shaded.org.apache.curator.framework.imps.Backgrounding;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorEventImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import io.mantisrx.shaded.org.apache.curator.framework.imps.FindAndDeleteProtectedNodeInBackground;
import io.mantisrx.shaded.org.apache.curator.framework.imps.OperationAndData;
import io.mantisrx.shaded.org.apache.curator.framework.imps.PathAndBytes;
import io.mantisrx.shaded.org.apache.curator.framework.imps.ProtectedMode;
import io.mantisrx.shaded.org.apache.curator.framework.imps.ProtectedUtils;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Predicate;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Iterables;
import io.mantisrx.shaded.org.apache.curator.utils.InternalACLProvider;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.CreateMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.Op;
import io.mantisrx.shaded.org.apache.zookeeper.data.ACL;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataTree;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBuilderImpl
implements CreateBuilder,
CreateBuilder2,
BackgroundOperation<PathAndBytes>,
ErrorListenerPathAndBytesable<String> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkImpl client;
    private final ProtectedMode protectedMode = new ProtectedMode();
    private CreateMode createMode;
    private Backgrounding backgrounding;
    private boolean createParentsIfNeeded;
    private boolean createParentsAsContainers;
    private boolean compress;
    private boolean setDataIfExists;
    private int setDataIfExistsVersion = -1;
    private ACLing acling;
    private Stat storingStat;
    private long ttl;
    @VisibleForTesting
    boolean failNextCreateForTesting = false;
    @VisibleForTesting
    volatile boolean debugForceFindProtectedNode = false;

    CreateBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.createMode = CreateMode.PERSISTENT;
        this.backgrounding = new Backgrounding();
        this.acling = new ACLing(client.getAclProvider());
        this.createParentsIfNeeded = false;
        this.createParentsAsContainers = false;
        this.compress = false;
        this.setDataIfExists = false;
        this.storingStat = null;
        this.ttl = -1L;
    }

    public CreateBuilderImpl(CuratorFrameworkImpl client, CreateMode createMode, Backgrounding backgrounding, boolean createParentsIfNeeded, boolean createParentsAsContainers, boolean doProtected, boolean compress, boolean setDataIfExists, List<ACL> aclList, Stat storingStat, long ttl) {
        this.client = client;
        this.createMode = createMode;
        this.backgrounding = backgrounding;
        this.createParentsIfNeeded = createParentsIfNeeded;
        this.createParentsAsContainers = createParentsAsContainers;
        this.compress = compress;
        this.setDataIfExists = setDataIfExists;
        this.acling = new ACLing(client.getAclProvider(), aclList);
        this.storingStat = storingStat;
        this.ttl = ttl;
        if (doProtected) {
            this.protectedMode.setProtectedMode();
        }
    }

    public void setSetDataIfExistsVersion(int version) {
        this.setDataIfExistsVersion = version;
    }

    @Override
    public CreateBuilder2 orSetData() {
        return this.orSetData(-1);
    }

    @Override
    public CreateBuilder2 orSetData(int version) {
        this.setDataIfExists = true;
        this.setDataIfExistsVersion = version;
        return this;
    }

    @Override
    public CreateBuilderMain withTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    <T> TransactionCreateBuilder<T> asTransactionCreateBuilder(final T context, final CuratorMultiTransactionRecord transaction) {
        return new TransactionCreateBuilder<T>(){

            @Override
            public PathAndBytesable<T> withACL(List<ACL> aclList) {
                return this.withACL((List)aclList, false);
            }

            @Override
            public PathAndBytesable<T> withACL(List<ACL> aclList, boolean applyToParents) {
                CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
                return this;
            }

            @Override
            public TransactionCreateBuilder2<T> withTtl(long ttl) {
                CreateBuilderImpl.this.withTtl(ttl);
                return this;
            }

            @Override
            public ACLPathAndBytesable<T> withMode(CreateMode mode) {
                CreateBuilderImpl.this.withMode(mode);
                return this;
            }

            @Override
            public ACLCreateModePathAndBytesable<T> compressed() {
                CreateBuilderImpl.this.compressed();
                return this;
            }

            @Override
            public T forPath(String path2) throws Exception {
                return this.forPath(path2, CreateBuilderImpl.this.client.getDefaultData());
            }

            @Override
            public T forPath(String path2, byte[] data2) throws Exception {
                if (CreateBuilderImpl.this.compress) {
                    data2 = CreateBuilderImpl.this.client.getCompressionProvider().compress(path2, data2);
                }
                String fixedPath = CreateBuilderImpl.this.client.fixForNamespace(path2);
                transaction.add(Op.create(fixedPath, data2, CreateBuilderImpl.this.acling.getAclList(path2), CreateBuilderImpl.this.createMode, CreateBuilderImpl.this.ttl), OperationType.CREATE, path2);
                return context;
            }
        };
    }

    @Override
    public CreateBackgroundModeStatACLable compressed() {
        this.compress = true;
        return new CreateBackgroundModeStatACLable(){

            @Override
            public CreateBackgroundModeACLable storingStatIn(Stat stat) {
                CreateBuilderImpl.this.storingStat = stat;
                return CreateBuilderImpl.this.asCreateBackgroundModeACLable();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                CreateBuilderImpl.this.createParentsIfNeeded = true;
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentContainersIfNeeded() {
                CreateBuilderImpl.this.setCreateParentsAsContainers();
                return this.creatingParentsIfNeeded();
            }

            @Override
            public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
                return CreateBuilderImpl.this.withProtectedEphemeralSequential();
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path2, byte[] data2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2, data2);
            }

            @Override
            public String forPath(String path2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
        return this.withACL((List)aclList, false);
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
        this.acling = new ACLing(this.client.getAclProvider(), aclList, applyToParents);
        return new ACLBackgroundPathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public String forPath(String path2, byte[] data2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2, data2);
            }

            @Override
            public String forPath(String path2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2);
            }
        };
    }

    @Override
    public ProtectACLCreateModeStatPathAndBytesable<String> creatingParentContainersIfNeeded() {
        this.setCreateParentsAsContainers();
        return this.creatingParentsIfNeeded();
    }

    private void setCreateParentsAsContainers() {
        if (this.client.useContainerParentsIfAvailable()) {
            this.createParentsAsContainers = true;
        }
    }

    @Override
    public ProtectACLCreateModeStatPathAndBytesable<String> creatingParentsIfNeeded() {
        this.createParentsIfNeeded = true;
        return new ProtectACLCreateModeStatPathAndBytesable<String>(){

            @Override
            public ACLCreateModeBackgroundPathAndBytesable<String> withProtection() {
                return CreateBuilderImpl.this.withProtection();
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return this.withACL((List)aclList, false);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path2, byte[] data2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2, data2);
            }

            @Override
            public String forPath(String path2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> storingStatIn(Stat stat) {
                CreateBuilderImpl.this.storingStat = stat;
                return CreateBuilderImpl.this;
            }
        };
    }

    @Override
    public ACLCreateModeStatBackgroundPathAndBytesable<String> withProtection() {
        this.protectedMode.setProtectedMode();
        return this.asACLCreateModeStatBackgroundPathAndBytesable();
    }

    @Override
    public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
        this.protectedMode.setProtectedMode();
        this.createMode = CreateMode.EPHEMERAL_SEQUENTIAL;
        return new ACLPathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public String forPath(String path2, byte[] data2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2, data2);
            }

            @Override
            public String forPath(String path2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
        this.createMode = mode;
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public PathAndBytesable<String> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public String forPath(String path2) throws Exception {
        return this.forPath(path2, this.client.getDefaultData());
    }

    @Override
    public String forPath(String givenPath, byte[] data2) throws Exception {
        if (this.compress) {
            data2 = this.client.getCompressionProvider().compress(givenPath, data2);
        }
        String adjustedPath = this.adjustPath(this.client.fixForNamespace(givenPath, this.createMode.isSequential()));
        List<ACL> aclList = this.acling.getAclList(adjustedPath);
        this.client.getSchemaSet().getSchema(givenPath).validateCreate(this.createMode, givenPath, data2, aclList);
        String returnPath = null;
        if (this.backgrounding.inBackground()) {
            this.pathInBackground(adjustedPath, data2, givenPath);
        } else {
            String path2 = this.protectedPathInForeground(adjustedPath, data2, aclList);
            returnPath = this.client.unfixForNamespace(path2);
        }
        return returnPath;
    }

    private String protectedPathInForeground(String adjustedPath, byte[] data2, List<ACL> aclList) throws Exception {
        try {
            return this.pathInForeground(adjustedPath, data2, aclList);
        }
        catch (Exception e2) {
            ThreadUtils.checkInterrupted(e2);
            if ((e2 instanceof KeeperException.ConnectionLossException || !(e2 instanceof KeeperException)) && this.protectedMode.doProtected()) {
                new FindAndDeleteProtectedNodeInBackground(this.client, ZKPaths.getPathAndNode(adjustedPath).getPath(), this.protectedMode.protectedId()).execute();
                this.protectedMode.resetProtectedId();
            }
            throw e2;
        }
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("CreateBuilderImpl-Background");
            final byte[] data2 = operationAndData.getData().getData();
            AsyncCallback.Create2Callback callback = new AsyncCallback.Create2Callback(){

                @Override
                public void processResult(int rc, String path2, Object ctx, String name2, Stat stat) {
                    trace.setReturnCode(rc).setRequestBytesLength(data2).setPath(path2).commit();
                    if (stat != null && CreateBuilderImpl.this.storingStat != null) {
                        DataTree.copyStat(stat, CreateBuilderImpl.this.storingStat);
                    }
                    if (rc == KeeperException.Code.NONODE.intValue() && CreateBuilderImpl.this.createParentsIfNeeded) {
                        CreateBuilderImpl.backgroundCreateParentsThenNode(CreateBuilderImpl.this.client, operationAndData, ((PathAndBytes)operationAndData.getData()).getPath(), CreateBuilderImpl.this.backgrounding, CreateBuilderImpl.this.acling.getACLProviderForParents(), CreateBuilderImpl.this.createParentsAsContainers);
                    } else if (rc == KeeperException.Code.NODEEXISTS.intValue() && CreateBuilderImpl.this.setDataIfExists) {
                        CreateBuilderImpl.this.backgroundSetData(CreateBuilderImpl.this.client, operationAndData, ((PathAndBytes)operationAndData.getData()).getPath(), CreateBuilderImpl.this.backgrounding);
                    } else {
                        CreateBuilderImpl.this.sendBackgroundResponse(rc, path2, ctx, name2, stat, operationAndData);
                    }
                }
            };
            this.client.getZooKeeper().create(operationAndData.getData().getPath(), data2, this.acling.getAclList(operationAndData.getData().getPath()), this.createMode, callback, this.backgrounding.getContext(), this.ttl);
        }
        catch (Throwable e2) {
            this.backgrounding.checkError(e2, null);
        }
    }

    @Override
    public CreateProtectACLCreateModePathAndBytesable<String> storingStatIn(Stat stat) {
        this.storingStat = stat;
        return new CreateProtectACLCreateModePathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public String forPath(String path2, byte[] data2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2, data2);
            }

            @Override
            public String forPath(String path2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public ACLCreateModeBackgroundPathAndBytesable<String> withProtection() {
                return CreateBuilderImpl.this.withProtection();
            }

            @Override
            public ProtectACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                return CreateBuilderImpl.this.creatingParentsIfNeeded();
            }

            @Override
            public ProtectACLCreateModePathAndBytesable<String> creatingParentContainersIfNeeded() {
                return CreateBuilderImpl.this.creatingParentContainersIfNeeded();
            }
        };
    }

    static <T> void backgroundCreateParentsThenNode(final CuratorFrameworkImpl client, final OperationAndData<T> mainOperationAndData, final String path2, Backgrounding backgrounding, final InternalACLProvider aclProvider, final boolean createParentsAsContainers) {
        BackgroundOperation operation = new BackgroundOperation<T>(){

            @Override
            public void performBackgroundOperation(OperationAndData<T> dummy) throws Exception {
                block2: {
                    try {
                        ZKPaths.mkdirs(client.getZooKeeper(), path2, false, aclProvider, createParentsAsContainers);
                    }
                    catch (KeeperException e2) {
                        if (client.getZookeeperClient().getRetryPolicy().allowRetry(e2)) break block2;
                        throw e2;
                    }
                }
                client.queueOperation(mainOperationAndData);
            }
        };
        OperationAndData<T> parentOperation = new OperationAndData<T>(operation, mainOperationAndData.getData(), null, null, backgrounding.getContext(), null);
        client.queueOperation(parentOperation);
    }

    private void backgroundSetData(final CuratorFrameworkImpl client, final OperationAndData<PathAndBytes> mainOperationAndData, final String path2, final Backgrounding backgrounding) {
        final AsyncCallback.StatCallback statCallback = new AsyncCallback.StatCallback(){

            @Override
            public void processResult(int rc, String path2, Object ctx, Stat stat) {
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    client.queueOperation(mainOperationAndData);
                } else {
                    CreateBuilderImpl.this.sendBackgroundResponse(rc, path2, ctx, path2, stat, mainOperationAndData);
                }
            }
        };
        BackgroundOperation<PathAndBytes> operation = new BackgroundOperation<PathAndBytes>(){

            @Override
            public void performBackgroundOperation(OperationAndData<PathAndBytes> op) throws Exception {
                try {
                    client.getZooKeeper().setData(path2, ((PathAndBytes)mainOperationAndData.getData()).getData(), CreateBuilderImpl.this.setDataIfExistsVersion, statCallback, backgrounding.getContext());
                }
                catch (KeeperException keeperException) {
                    // empty catch block
                }
            }
        };
        client.queueOperation(new OperationAndData<Object>(operation, null, null, null, null, null));
    }

    private void sendBackgroundResponse(int rc, String path2, Object ctx, String name2, Stat stat, OperationAndData<PathAndBytes> operationAndData) {
        path2 = this.client.unfixForNamespace(path2);
        name2 = this.client.unfixForNamespace(name2);
        CuratorEventImpl event = new CuratorEventImpl(this.client, CuratorEventType.CREATE, rc, path2, name2, ctx, stat, null, null, null, null, null);
        this.client.processBackgroundOperation(operationAndData, event);
    }

    private ACLCreateModePathAndBytesable<String> asACLCreateModePathAndBytesable() {
        return new ACLCreateModePathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
                return this;
            }

            @Override
            public ACLPathAndBytesable<String> withMode(CreateMode mode) {
                CreateBuilderImpl.this.createMode = mode;
                return new ACLPathAndBytesable<String>(){

                    @Override
                    public PathAndBytesable<String> withACL(List<ACL> aclList) {
                        return CreateBuilderImpl.this.withACL((List)aclList);
                    }

                    @Override
                    public PathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                        return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
                    }

                    @Override
                    public String forPath(String path2, byte[] data2) throws Exception {
                        return CreateBuilderImpl.this.forPath(path2, data2);
                    }

                    @Override
                    public String forPath(String path2) throws Exception {
                        return CreateBuilderImpl.this.forPath(path2);
                    }
                };
            }

            @Override
            public String forPath(String path2, byte[] data2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2, data2);
            }

            @Override
            public String forPath(String path2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2);
            }
        };
    }

    private CreateBackgroundModeACLable asCreateBackgroundModeACLable() {
        return new CreateBackgroundModeACLable(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                return CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public String forPath(String path2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2);
            }

            @Override
            public String forPath(String path2, byte[] data2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2, data2);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
                return CreateBuilderImpl.this.withProtectedEphemeralSequential();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
                CreateBuilderImpl.this.createParentsIfNeeded = true;
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }

            @Override
            public ACLCreateModePathAndBytesable<String> creatingParentContainersIfNeeded() {
                CreateBuilderImpl.this.setCreateParentsAsContainers();
                return CreateBuilderImpl.this.asACLCreateModePathAndBytesable();
            }
        };
    }

    private ACLCreateModeStatBackgroundPathAndBytesable<String> asACLCreateModeStatBackgroundPathAndBytesable() {
        return new ACLCreateModeStatBackgroundPathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList, boolean applyToParents) {
                CreateBuilderImpl.this.withACL((List)aclList, applyToParents);
                return this;
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
                return CreateBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public String forPath(String path2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2);
            }

            @Override
            public String forPath(String path2, byte[] data2) throws Exception {
                return CreateBuilderImpl.this.forPath(path2, data2);
            }

            @Override
            public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
                return CreateBuilderImpl.this.withMode(mode);
            }

            @Override
            public ACLCreateModeBackgroundPathAndBytesable<String> storingStatIn(Stat stat) {
                CreateBuilderImpl.this.storingStat = stat;
                return CreateBuilderImpl.this;
            }
        };
    }

    private void pathInBackground(final String path2, final byte[] data2, final String givenPath) {
        final AtomicBoolean firstTime = new AtomicBoolean(true);
        OperationAndData<PathAndBytes> operationAndData = new OperationAndData<PathAndBytes>((BackgroundOperation)this, new PathAndBytes(path2, data2), this.backgrounding.getCallback(), (OperationAndData.ErrorCallback)new OperationAndData.ErrorCallback<PathAndBytes>(){

            @Override
            public void retriesExhausted(OperationAndData<PathAndBytes> operationAndData) {
                if (CreateBuilderImpl.this.protectedMode.doProtected()) {
                    new FindAndDeleteProtectedNodeInBackground(CreateBuilderImpl.this.client, ZKPaths.getPathAndNode(path2).getPath(), CreateBuilderImpl.this.protectedMode.protectedId()).execute();
                    CreateBuilderImpl.this.protectedMode.resetProtectedId();
                }
            }
        }, this.backgrounding.getContext(), null){

            @Override
            void callPerformBackgroundOperation() throws Exception {
                boolean callSuper = true;
                boolean localFirstTime = firstTime.getAndSet(false) && !CreateBuilderImpl.this.debugForceFindProtectedNode;
                CreateBuilderImpl.this.protectedMode.checkSetSessionId(CreateBuilderImpl.this.client, CreateBuilderImpl.this.createMode);
                if (!localFirstTime && CreateBuilderImpl.this.protectedMode.doProtected()) {
                    CreateBuilderImpl.this.debugForceFindProtectedNode = false;
                    String createdPath = null;
                    try {
                        createdPath = CreateBuilderImpl.this.findProtectedNodeInForeground(path2);
                    }
                    catch (KeeperException.ConnectionLossException e2) {
                        CreateBuilderImpl.this.sendBackgroundResponse(KeeperException.Code.CONNECTIONLOSS.intValue(), path2, CreateBuilderImpl.this.backgrounding.getContext(), null, null, this);
                        callSuper = false;
                    }
                    if (createdPath != null) {
                        try {
                            CreateBuilderImpl.this.sendBackgroundResponse(KeeperException.Code.OK.intValue(), createdPath, CreateBuilderImpl.this.backgrounding.getContext(), createdPath, null, this);
                        }
                        catch (Exception e3) {
                            ThreadUtils.checkInterrupted(e3);
                            CreateBuilderImpl.this.client.logError("Processing protected create for path: " + givenPath, e3);
                        }
                        callSuper = false;
                    }
                }
                if (CreateBuilderImpl.this.failNextCreateForTesting) {
                    CreateBuilderImpl.this.failNextCreateForTesting = false;
                    CreateBuilderImpl.this.pathInForeground(path2, data2, CreateBuilderImpl.this.acling.getAclList(path2));
                    throw new KeeperException.ConnectionLossException();
                }
                if (callSuper) {
                    super.callPerformBackgroundOperation();
                }
            }
        };
        this.client.processBackgroundOperation(operationAndData, null);
    }

    private String pathInForeground(final String path2, final byte[] data2, final List<ACL> aclList) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("CreateBuilderImpl-Foreground");
        final AtomicBoolean firstTime = new AtomicBoolean(true);
        String returnPath = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<String>(){

            @Override
            public String call() throws Exception {
                boolean localFirstTime = firstTime.getAndSet(false) && !CreateBuilderImpl.this.debugForceFindProtectedNode;
                CreateBuilderImpl.this.protectedMode.checkSetSessionId(CreateBuilderImpl.this.client, CreateBuilderImpl.this.createMode);
                String createdPath = null;
                if (!localFirstTime && CreateBuilderImpl.this.protectedMode.doProtected()) {
                    CreateBuilderImpl.this.debugForceFindProtectedNode = false;
                    createdPath = CreateBuilderImpl.this.findProtectedNodeInForeground(path2);
                }
                if (createdPath == null) {
                    try {
                        createdPath = CreateBuilderImpl.this.client.getZooKeeper().create(path2, data2, (List<ACL>)aclList, CreateBuilderImpl.this.createMode, CreateBuilderImpl.this.storingStat, CreateBuilderImpl.this.ttl);
                    }
                    catch (KeeperException.NoNodeException e2) {
                        if (CreateBuilderImpl.this.createParentsIfNeeded) {
                            ZKPaths.mkdirs(CreateBuilderImpl.this.client.getZooKeeper(), path2, false, CreateBuilderImpl.this.acling.getACLProviderForParents(), CreateBuilderImpl.this.createParentsAsContainers);
                            createdPath = CreateBuilderImpl.this.client.getZooKeeper().create(path2, data2, CreateBuilderImpl.this.acling.getAclList(path2), CreateBuilderImpl.this.createMode, CreateBuilderImpl.this.storingStat, CreateBuilderImpl.this.ttl);
                        }
                        throw e2;
                    }
                    catch (KeeperException.NodeExistsException e3) {
                        if (CreateBuilderImpl.this.setDataIfExists) {
                            Stat setStat = CreateBuilderImpl.this.client.getZooKeeper().setData(path2, data2, CreateBuilderImpl.this.setDataIfExistsVersion);
                            if (CreateBuilderImpl.this.storingStat != null) {
                                DataTree.copyStat(setStat, CreateBuilderImpl.this.storingStat);
                            }
                            createdPath = path2;
                        }
                        throw e3;
                    }
                }
                if (CreateBuilderImpl.this.failNextCreateForTesting) {
                    CreateBuilderImpl.this.failNextCreateForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                return createdPath;
            }
        });
        trace.setRequestBytesLength(data2).setPath(path2).commit();
        return returnPath;
    }

    private String findProtectedNodeInForeground(final String path2) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("CreateBuilderImpl-findProtectedNodeInForeground");
        String returnPath = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<String>(){

            @Override
            public String call() throws Exception {
                String foundNode = null;
                try {
                    ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode(path2);
                    List<String> children2 = CreateBuilderImpl.this.client.getZooKeeper().getChildren(pathAndNode.getPath(), false);
                    foundNode = CreateBuilderImpl.findNode(children2, pathAndNode.getPath(), CreateBuilderImpl.this.protectedMode.protectedId());
                    CreateBuilderImpl.this.log.debug("Protected mode findNode result: {}", (Object)foundNode);
                    foundNode = CreateBuilderImpl.this.protectedMode.validateFoundNode(CreateBuilderImpl.this.client, CreateBuilderImpl.this.createMode, foundNode);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
                return foundNode;
            }
        });
        trace.setPath(path2).commit();
        return returnPath;
    }

    @VisibleForTesting
    String adjustPath(String path2) throws Exception {
        return ProtectedUtils.toProtectedZNodePath(path2, this.protectedMode.protectedId());
    }

    static String findNode(List<String> children2, String path2, String protectedId) {
        final String protectedPrefix = ProtectedUtils.getProtectedPrefix(protectedId);
        String foundNode = Iterables.find(children2, new Predicate<String>(){

            @Override
            public boolean apply(String node2) {
                return node2.startsWith(protectedPrefix);
            }
        }, null);
        if (foundNode != null) {
            foundNode = ZKPaths.makePath(path2, foundNode);
        }
        return foundNode;
    }
}

