/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.imps;

import io.mantisrx.shaded.org.apache.curator.RetryLoop;
import io.mantisrx.shaded.org.apache.curator.drivers.OperationTrace;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundCallback;
import io.mantisrx.shaded.org.apache.curator.framework.api.CuratorEventType;
import io.mantisrx.shaded.org.apache.curator.framework.api.ErrorListenerPathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.GetACLBuilder;
import io.mantisrx.shaded.org.apache.curator.framework.api.Pathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.UnhandledErrorListener;
import io.mantisrx.shaded.org.apache.curator.framework.imps.BackgroundOperation;
import io.mantisrx.shaded.org.apache.curator.framework.imps.Backgrounding;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorEventImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.OperationAndData;
import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.data.ACL;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class GetACLBuilderImpl
implements GetACLBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<List<ACL>> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private Stat responseStat;

    GetACLBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.responseStat = new Stat();
    }

    public GetACLBuilderImpl(CuratorFrameworkImpl client, Backgrounding backgrounding, Stat responseStat) {
        this.client = client;
        this.backgrounding = backgrounding;
        this.responseStat = responseStat;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public Pathable<List<ACL>> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public Pathable<List<ACL>> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("GetACLBuilderImpl-Background");
            AsyncCallback.ACLCallback callback = new AsyncCallback.ACLCallback(){

                @Override
                public void processResult(int rc, String path2, Object ctx, List<ACL> acl, Stat stat) {
                    trace.setReturnCode(rc).setPath(path2).setStat(stat).commit();
                    CuratorEventImpl event = new CuratorEventImpl(GetACLBuilderImpl.this.client, CuratorEventType.GET_ACL, rc, path2, null, ctx, stat, null, null, null, acl, null);
                    GetACLBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            };
            this.client.getZooKeeper().getACL(operationAndData.getData(), this.responseStat, callback, this.backgrounding.getContext());
        }
        catch (Throwable e2) {
            this.backgrounding.checkError(e2, null);
        }
    }

    @Override
    public List<ACL> forPath(String path2) throws Exception {
        path2 = this.client.fixForNamespace(path2);
        List<ACL> result = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path2, this.backgrounding.getCallback(), null, this.backgrounding.getContext(), null), null);
        } else {
            result = this.pathInForeground(path2);
        }
        return result;
    }

    private List<ACL> pathInForeground(final String path2) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("GetACLBuilderImpl-Foreground");
        List<ACL> result = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<List<ACL>>(){

            @Override
            public List<ACL> call() throws Exception {
                return GetACLBuilderImpl.this.client.getZooKeeper().getACL(path2, GetACLBuilderImpl.this.responseStat);
            }
        });
        trace.setPath(path2).setStat(this.responseStat).commit();
        return result;
    }
}

