/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.imps;

import io.mantisrx.shaded.org.apache.curator.RetryLoop;
import io.mantisrx.shaded.org.apache.curator.drivers.OperationTrace;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundCallback;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundPathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.CuratorEventType;
import io.mantisrx.shaded.org.apache.curator.framework.api.CuratorWatcher;
import io.mantisrx.shaded.org.apache.curator.framework.api.ErrorListenerPathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.GetDataBuilder;
import io.mantisrx.shaded.org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import io.mantisrx.shaded.org.apache.curator.framework.api.Pathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.UnhandledErrorListener;
import io.mantisrx.shaded.org.apache.curator.framework.api.WatchPathable;
import io.mantisrx.shaded.org.apache.curator.framework.imps.BackgroundOperation;
import io.mantisrx.shaded.org.apache.curator.framework.imps.Backgrounding;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorEventImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.OperationAndData;
import io.mantisrx.shaded.org.apache.curator.framework.imps.Watching;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataTree;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDataBuilderImpl
implements GetDataBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<byte[]> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkImpl client;
    private Stat responseStat;
    private Watching watching;
    private Backgrounding backgrounding;
    private boolean decompress;

    GetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.responseStat = null;
        this.watching = new Watching(client);
        this.backgrounding = new Backgrounding();
        this.decompress = false;
    }

    public GetDataBuilderImpl(CuratorFrameworkImpl client, Stat responseStat, Watcher watcher, Backgrounding backgrounding, boolean decompress) {
        this.client = client;
        this.responseStat = responseStat;
        this.watching = new Watching(client, watcher);
        this.backgrounding = backgrounding;
        this.decompress = decompress;
    }

    @Override
    public GetDataWatchBackgroundStatable decompressed() {
        this.decompress = true;
        return new GetDataWatchBackgroundStatable(){

            @Override
            public ErrorListenerPathable<byte[]> inBackground() {
                return GetDataBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Object context) {
                return GetDataBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return GetDataBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathable<byte[]> inBackground(Object context) {
                return GetDataBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback) {
                return GetDataBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Executor executor) {
                return GetDataBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public byte[] forPath(String path2) throws Exception {
                return GetDataBuilderImpl.this.forPath(path2);
            }

            @Override
            public WatchPathable<byte[]> storingStatIn(Stat stat) {
                return GetDataBuilderImpl.this.storingStatIn(stat);
            }

            @Override
            public BackgroundPathable<byte[]> watched() {
                return GetDataBuilderImpl.this.watched();
            }

            @Override
            public BackgroundPathable<byte[]> usingWatcher(Watcher watcher) {
                return GetDataBuilderImpl.this.usingWatcher(watcher);
            }

            @Override
            public BackgroundPathable<byte[]> usingWatcher(CuratorWatcher watcher) {
                return GetDataBuilderImpl.this.usingWatcher(watcher);
            }
        };
    }

    @Override
    public WatchPathable<byte[]> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return new WatchPathable<byte[]>(){

            @Override
            public byte[] forPath(String path2) throws Exception {
                return GetDataBuilderImpl.this.forPath(path2);
            }

            @Override
            public Pathable<byte[]> watched() {
                GetDataBuilderImpl.this.watched();
                return GetDataBuilderImpl.this;
            }

            @Override
            public Pathable<byte[]> usingWatcher(Watcher watcher) {
                GetDataBuilderImpl.this.usingWatcher(watcher);
                return GetDataBuilderImpl.this;
            }

            @Override
            public Pathable<byte[]> usingWatcher(CuratorWatcher watcher) {
                GetDataBuilderImpl.this.usingWatcher(watcher);
                return GetDataBuilderImpl.this;
            }
        };
    }

    @Override
    public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<byte[]> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<byte[]> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<byte[]> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public BackgroundPathable<byte[]> watched() {
        this.watching = new Watching(this.client, true);
        return this;
    }

    @Override
    public BackgroundPathable<byte[]> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public BackgroundPathable<byte[]> usingWatcher(CuratorWatcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("GetDataBuilderImpl-Background");
            AsyncCallback.DataCallback callback = new AsyncCallback.DataCallback(){

                @Override
                public void processResult(int rc, String path2, Object ctx, byte[] data2, Stat stat) {
                    GetDataBuilderImpl.this.watching.commitWatcher(rc, false);
                    trace.setReturnCode(rc).setResponseBytesLength(data2).setPath(path2).setWithWatcher(GetDataBuilderImpl.this.watching.hasWatcher()).setStat(stat).commit();
                    if (GetDataBuilderImpl.this.responseStat != null && stat != null) {
                        DataTree.copyStat(stat, GetDataBuilderImpl.this.responseStat);
                    }
                    if (GetDataBuilderImpl.this.decompress && data2 != null) {
                        try {
                            data2 = GetDataBuilderImpl.this.client.getCompressionProvider().decompress(path2, data2);
                        }
                        catch (Exception e2) {
                            ThreadUtils.checkInterrupted(e2);
                            GetDataBuilderImpl.this.log.error("Decompressing for path: " + path2, e2);
                            rc = KeeperException.Code.DATAINCONSISTENCY.intValue();
                        }
                    }
                    CuratorEventImpl event = new CuratorEventImpl(GetDataBuilderImpl.this.client, CuratorEventType.GET_DATA, rc, path2, null, ctx, stat, data2, null, null, null, null);
                    GetDataBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            };
            if (this.watching.isWatched()) {
                this.client.getZooKeeper().getData(operationAndData.getData(), true, callback, this.backgrounding.getContext());
            } else {
                this.client.getZooKeeper().getData(operationAndData.getData(), this.watching.getWatcher(operationAndData.getData()), callback, this.backgrounding.getContext());
            }
        }
        catch (Throwable e2) {
            this.backgrounding.checkError(e2, this.watching);
        }
    }

    @Override
    public byte[] forPath(String path2) throws Exception {
        this.client.getSchemaSet().getSchema(path2).validateWatch(path2, this.watching.isWatched() || this.watching.hasWatcher());
        path2 = this.client.fixForNamespace(path2);
        byte[] responseData = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path2, this.backgrounding.getCallback(), null, this.backgrounding.getContext(), this.watching), null);
        } else {
            responseData = this.pathInForeground(path2);
        }
        return responseData;
    }

    private byte[] pathInForeground(final String path2) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("GetDataBuilderImpl-Foreground");
        byte[] responseData = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                byte[] responseData;
                if (GetDataBuilderImpl.this.watching.isWatched()) {
                    responseData = GetDataBuilderImpl.this.client.getZooKeeper().getData(path2, true, GetDataBuilderImpl.this.responseStat);
                } else {
                    responseData = GetDataBuilderImpl.this.client.getZooKeeper().getData(path2, GetDataBuilderImpl.this.watching.getWatcher(path2), GetDataBuilderImpl.this.responseStat);
                    GetDataBuilderImpl.this.watching.commitWatcher(KeeperException.Code.OK.intValue(), false);
                }
                return responseData;
            }
        });
        trace.setResponseBytesLength(responseData).setPath(path2).setWithWatcher(this.watching.hasWatcher()).setStat(this.responseStat).commit();
        return this.decompress ? this.client.getCompressionProvider().decompress(path2, responseData) : responseData;
    }
}

