/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.cache;

import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.ChildData;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.CuratorCacheStorage;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

class StandardCuratorCacheStorage
implements CuratorCacheStorage {
    private final Map<String, ChildData> dataMap = new ConcurrentHashMap<String, ChildData>();
    private final boolean cacheBytes;

    StandardCuratorCacheStorage(boolean cacheBytes) {
        this.cacheBytes = cacheBytes;
    }

    @Override
    public Optional<ChildData> put(ChildData data2) {
        ChildData localData = this.cacheBytes ? data2 : new ChildData(data2.getPath(), data2.getStat(), null);
        return Optional.ofNullable(this.dataMap.put(data2.getPath(), localData));
    }

    @Override
    public Optional<ChildData> remove(String path2) {
        return Optional.ofNullable(this.dataMap.remove(path2));
    }

    @Override
    public Optional<ChildData> get(String path2) {
        return Optional.ofNullable(this.dataMap.get(path2));
    }

    @Override
    public int size() {
        return this.dataMap.size();
    }

    @Override
    public Stream<ChildData> stream() {
        return this.dataMap.values().stream();
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }
}

