/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.locks;

import io.mantisrx.shaded.org.apache.curator.RetryLoop;
import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.WatcherRemoveCuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundPathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.ChildrenDeletable;
import io.mantisrx.shaded.org.apache.curator.framework.api.PathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkState;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.InterProcessMutex;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.Lease;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.shared.SharedCountListener;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.shared.SharedCountReader;
import io.mantisrx.shaded.org.apache.curator.framework.state.ConnectionState;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Sets;
import io.mantisrx.shaded.org.apache.curator.utils.CloseableUtils;
import io.mantisrx.shaded.org.apache.curator.utils.PathUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import io.mantisrx.shaded.org.apache.zookeeper.CreateMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.WatchedEvent;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterProcessSemaphoreV2 {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InterProcessMutex lock;
    private final WatcherRemoveCuratorFramework client;
    private final String leasesPath;
    private final Watcher watcher = new Watcher(){

        @Override
        public void process(WatchedEvent event) {
            InterProcessSemaphoreV2.this.client.postSafeNotify(InterProcessSemaphoreV2.this);
        }
    };
    private volatile byte[] nodeData;
    private volatile int maxLeases;
    private static final String LOCK_PARENT = "locks";
    private static final String LEASE_PARENT = "leases";
    private static final String LEASE_BASE_NAME = "lease-";
    public static final Set<String> LOCK_SCHEMA = Sets.newHashSet("locks", "leases");
    static volatile CountDownLatch debugAcquireLatch = null;
    static volatile CountDownLatch debugFailedGetChildrenLatch = null;
    volatile CountDownLatch debugWaitLatch = null;

    public InterProcessSemaphoreV2(CuratorFramework client, String path2, int maxLeases) {
        this(client, path2, maxLeases, null);
    }

    public InterProcessSemaphoreV2(CuratorFramework client, String path2, SharedCountReader count2) {
        this(client, path2, 0, count2);
    }

    private InterProcessSemaphoreV2(final CuratorFramework client, String path2, int maxLeases, SharedCountReader count2) {
        this.client = client.newWatcherRemoveCuratorFramework();
        path2 = PathUtils.validatePath(path2);
        this.lock = new InterProcessMutex(client, ZKPaths.makePath(path2, LOCK_PARENT));
        this.maxLeases = count2 != null ? count2.getCount() : maxLeases;
        this.leasesPath = ZKPaths.makePath(path2, LEASE_PARENT);
        if (count2 != null) {
            count2.addListener(new SharedCountListener(){

                @Override
                public void countHasChanged(SharedCountReader sharedCount, int newCount) throws Exception {
                    InterProcessSemaphoreV2.this.maxLeases = newCount;
                    client.postSafeNotify(InterProcessSemaphoreV2.this);
                }

                @Override
                public void stateChanged(CuratorFramework client2, ConnectionState newState) {
                }
            });
        }
    }

    public void setNodeData(byte[] nodeData) {
        this.nodeData = nodeData != null ? Arrays.copyOf(nodeData, nodeData.length) : null;
    }

    public Collection<String> getParticipantNodes() throws Exception {
        return (Collection)this.client.getChildren().forPath(this.leasesPath);
    }

    public void returnAll(Collection<Lease> leases) {
        for (Lease l : leases) {
            CloseableUtils.closeQuietly(l);
        }
    }

    public void returnLease(Lease lease) {
        CloseableUtils.closeQuietly(lease);
    }

    public Lease acquire() throws Exception {
        Collection<Lease> leases = this.acquire(1, 0L, null);
        return leases.iterator().next();
    }

    public Collection<Lease> acquire(int qty) throws Exception {
        return this.acquire(qty, 0L, null);
    }

    public Lease acquire(long time2, TimeUnit unit) throws Exception {
        Collection<Lease> leases = this.acquire(1, time2, unit);
        return leases != null ? leases.iterator().next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Lease> acquire(int qty, long time, TimeUnit unit) throws Exception {
        block13: {
            startMs = System.currentTimeMillis();
            hasWait = unit != null;
            waitMs = hasWait != false ? TimeUnit.MILLISECONDS.convert(time, unit) : 0L;
            Preconditions.checkArgument(qty > 0, "qty cannot be 0");
            builder = ImmutableList.builder();
            success = false;
            while (true) {
                if (qty-- <= 0) {
                    success = true;
                    return builder.build();
                }
                break block13;
                break;
            }
            finally {
                if (!success) {
                    this.returnAll(builder.build());
                }
            }
        }
        retryCount = 0;
        startMillis = System.currentTimeMillis();
        isDone = false;
        block10: while (true) {
            if (isDone) ** continue;
            switch (4.$SwitchMap$org$apache$curator$framework$recipes$locks$InterProcessSemaphoreV2$InternalAcquireResult[this.internalAcquire1Lease(builder, startMs, hasWait, waitMs).ordinal()]) {
                case 1: {
                    isDone = true;
                    break;
                }
                case 2: {
                    var16_12 = null;
                    return var16_12;
                }
                case 3: {
                    if (this.client.getZookeeperClient().getRetryPolicy().allowRetry(retryCount++, System.currentTimeMillis() - startMillis, RetryLoop.getDefaultRetrySleeper())) continue block10;
                    throw new KeeperException.NoNodeException("Sequential path not found - possible session loss");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InternalAcquireResult internalAcquire1Lease(ImmutableList.Builder<Lease> builder, long startMs, boolean hasWait, long waitMs) throws Exception {
        if (this.client.getState() != CuratorFrameworkState.STARTED) {
            return InternalAcquireResult.RETURN_NULL;
        }
        if (hasWait) {
            thisWaitMs = this.getThisWaitMs(startMs, waitMs);
            if (!this.lock.acquire(thisWaitMs, TimeUnit.MILLISECONDS)) {
                return InternalAcquireResult.RETURN_NULL;
            }
        } else {
            this.lock.acquire();
        }
        lease = null;
        success = false;
        createBuilder = (PathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withProtection().withMode(CreateMode.EPHEMERAL_SEQUENTIAL);
        path = this.nodeData != null ? (String)createBuilder.forPath(ZKPaths.makePath(this.leasesPath, "lease-"), this.nodeData) : (String)createBuilder.forPath(ZKPaths.makePath(this.leasesPath, "lease-"));
        nodeName = ZKPaths.getNodeFromPath(path);
        lease = this.makeLease(path);
        if (InterProcessSemaphoreV2.debugAcquireLatch != null) {
            InterProcessSemaphoreV2.debugAcquireLatch.await();
        }
        try {
            var12_11 = this;
            synchronized (var12_11) lbl-1000:
            // 3 sources

            {
                while (true) {
                    try {
                        children = (List)((BackgroundPathable)this.client.getChildren().usingWatcher(this.watcher)).forPath(this.leasesPath);
                    }
                    catch (Exception e) {
                        if (InterProcessSemaphoreV2.debugFailedGetChildrenLatch == null) throw e;
                        InterProcessSemaphoreV2.debugFailedGetChildrenLatch.countDown();
                        throw e;
                    }
                    if (!children.contains(nodeName)) {
                        this.log.error("Sequential path not found: " + path);
                        e = InternalAcquireResult.RETRY_DUE_TO_MISSING_NODE;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 21, 9, 14] lbl32 : MonitorExitStatement: MONITOREXIT : var12_11
                        if (!success) {
                            this.returnLease(lease);
                        }
                        this.client.removeWatchers();
                        return e;
                    }
                    if (children.size() <= this.maxLeases) ** GOTO lbl64
                    if (!hasWait) ** GOTO lbl60
                    thisWaitMs = this.getThisWaitMs(startMs, waitMs);
                    if (thisWaitMs > 0L) ** GOTO lbl-1000
                    var16_16 = InternalAcquireResult.RETURN_NULL;
                    ** GOTO lbl-1000
                    break;
                }
            }
        }
        catch (Throwable var18_17) {
            if (!success) {
                this.returnLease(lease);
            }
            this.client.removeWatchers();
            throw var18_17;
            finally {
                this.lock.release();
            }
lbl-1000:
            // 1 sources

            {
                // MONITOREXIT @DISABLED, blocks:[0, 9, 11] lbl51 : MonitorExitStatement: MONITOREXIT : var12_11
                if (!success) {
                    this.returnLease(lease);
                }
                this.client.removeWatchers();
                return var16_16;
lbl-1000:
                // 1 sources

                {
                    if (this.debugWaitLatch != null) {
                        this.debugWaitLatch.countDown();
                    }
                    this.wait(thisWaitMs);
                    ** GOTO lbl-1000
lbl60:
                    // 1 sources

                    if (this.debugWaitLatch != null) {
                        this.debugWaitLatch.countDown();
                    }
                    this.wait();
                    ** continue;
lbl64:
                    // 1 sources

                    success = true;
                    // MONITOREXIT @DISABLED, blocks:[0, 7, 9, 11] lbl65 : MonitorExitStatement: MONITOREXIT : var12_11
                    if (!success) {
                        this.returnLease(lease);
                    }
                    this.client.removeWatchers();
                }
            }
        }
        builder.add((Object)Preconditions.checkNotNull(lease));
        return InternalAcquireResult.CONTINUE;
    }

    private long getThisWaitMs(long startMs, long waitMs) {
        long elapsedMs = System.currentTimeMillis() - startMs;
        return waitMs - elapsedMs;
    }

    private Lease makeLease(final String path2) {
        return new Lease(){

            @Override
            public void close() throws IOException {
                try {
                    ((ChildrenDeletable)InterProcessSemaphoreV2.this.client.delete().guaranteed()).forPath(path2);
                }
                catch (KeeperException.NoNodeException e2) {
                    InterProcessSemaphoreV2.this.log.warn("Lease already released", e2);
                }
                catch (Exception e3) {
                    ThreadUtils.checkInterrupted(e3);
                    throw new IOException(e3);
                }
            }

            @Override
            public byte[] getData() throws Exception {
                return (byte[])InterProcessSemaphoreV2.this.client.getData().forPath(path2);
            }

            @Override
            public String getNodeName() {
                return ZKPaths.getNodeFromPath(path2);
            }
        };
    }

    private static enum InternalAcquireResult {
        CONTINUE,
        RETURN_NULL,
        RETRY_DUE_TO_MISSING_NODE;

    }
}

