/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.schema;

import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.org.apache.curator.framework.schema.Schema;
import io.mantisrx.shaded.org.apache.curator.framework.schema.SchemaBuilder;
import io.mantisrx.shaded.org.apache.curator.framework.schema.SchemaSet;
import io.mantisrx.shaded.org.apache.curator.framework.schema.SchemaValidator;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class SchemaSetLoader {
    private final List<Schema> schemas;

    public SchemaSetLoader(String json2, SchemaValidatorMapper schemaValidatorMapper) {
        this(SchemaSetLoader.getRoot(new StringReader(json2)), schemaValidatorMapper);
    }

    public SchemaSetLoader(Reader jsonStream, SchemaValidatorMapper schemaValidatorMapper) {
        this(SchemaSetLoader.getRoot(jsonStream), schemaValidatorMapper);
    }

    public SchemaSetLoader(JsonNode root2, SchemaValidatorMapper schemaValidatorMapper) {
        ImmutableList.Builder<Schema> builder = ImmutableList.builder();
        this.read(builder, root2, schemaValidatorMapper);
        this.schemas = builder.build();
    }

    public SchemaSet toSchemaSet(boolean useDefaultSchema) {
        return new SchemaSet(this.schemas, useDefaultSchema);
    }

    public List<Schema> getSchemas() {
        return this.schemas;
    }

    private static JsonNode getRoot(Reader in) {
        try {
            return new ObjectMapper().readTree(in);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void read(ImmutableList.Builder<Schema> builder, JsonNode node2, SchemaValidatorMapper schemaValidatorMapper) {
        for (JsonNode child : node2) {
            this.readNode(builder, child, schemaValidatorMapper);
        }
    }

    private void readNode(ImmutableList.Builder<Schema> builder, JsonNode node2, SchemaValidatorMapper schemaValidatorMapper) {
        String name2 = this.getText(node2, "name", null);
        String path2 = this.getText(node2, "path", null);
        boolean isRegex = this.getBoolean(node2, "isRegex");
        if (name2 == null) {
            throw new RuntimeException("name is required at: " + node2);
        }
        if (path2 == null) {
            throw new RuntimeException("path is required at: " + node2);
        }
        SchemaBuilder schemaBuilder = isRegex ? Schema.builder(Pattern.compile(path2)) : Schema.builder(path2);
        String schemaValidatorName = this.getText(node2, "schemaValidator", null);
        if (schemaValidatorName != null) {
            if (schemaValidatorMapper == null) {
                throw new RuntimeException("No SchemaValidatorMapper provided but needed at: " + node2);
            }
            schemaBuilder.dataValidator(schemaValidatorMapper.getSchemaValidator(schemaValidatorName));
        }
        HashMap<String, String> metadata = Maps.newHashMap();
        if (node2.has("metadata")) {
            JsonNode metadataNode = node2.get("metadata");
            Iterator<String> fieldNameIterator = metadataNode.fieldNames();
            while (fieldNameIterator.hasNext()) {
                String fieldName = fieldNameIterator.next();
                metadata.put(fieldName, this.getText(metadataNode, fieldName, ""));
            }
        }
        Schema schema = schemaBuilder.name(name2).documentation(this.getText(node2, "documentation", "")).ephemeral(this.getAllowance(node2, "ephemeral")).sequential(this.getAllowance(node2, "sequential")).watched(this.getAllowance(node2, "watched")).canBeDeleted(this.getBoolean(node2, "canBeDeleted")).metadata(metadata).build();
        builder.add((Object)schema);
    }

    private String getText(JsonNode node2, String name2, String defaultValue) {
        JsonNode namedNode = node2.get(name2);
        return namedNode != null ? namedNode.asText() : defaultValue;
    }

    private boolean getBoolean(JsonNode node2, String name2) {
        JsonNode namedNode = node2.get(name2);
        return namedNode != null && namedNode.asBoolean();
    }

    private Schema.Allowance getAllowance(JsonNode node2, String name2) {
        JsonNode namedNode = node2.get(name2);
        try {
            return namedNode != null ? Schema.Allowance.valueOf(namedNode.asText().toUpperCase()) : Schema.Allowance.CAN;
        }
        catch (IllegalArgumentException ignore) {
            throw new RuntimeException("Must be one of: " + Arrays.toString((Object[])Schema.Allowance.values()) + " at " + node2);
        }
    }

    public static interface SchemaValidatorMapper {
        public SchemaValidator getSchemaValidator(String var1);
    }
}

