/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.state;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.listen.StandardListenerManager;
import io.mantisrx.shaded.org.apache.curator.framework.listen.UnaryListenerManager;
import io.mantisrx.shaded.org.apache.curator.framework.state.CircuitBreaker;
import io.mantisrx.shaded.org.apache.curator.framework.state.CircuitBreakingConnectionStateListener;
import io.mantisrx.shaded.org.apache.curator.framework.state.ConnectionStateListener;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

class CircuitBreakingManager
implements UnaryListenerManager<ConnectionStateListener> {
    private final StandardListenerManager<ConnectionStateListener> mainContainer = StandardListenerManager.standard();
    private final StandardListenerManager<ConnectionStateListener> doNotProxyContainer = StandardListenerManager.standard();
    private final CircuitBreakingConnectionStateListener masterListener;

    CircuitBreakingManager(CuratorFramework client, CircuitBreaker circuitBreaker) {
        ConnectionStateListener masterStateChanged = (__, newState) -> this.mainContainer.forEach((T listener) -> listener.stateChanged(client, newState));
        this.masterListener = new CircuitBreakingConnectionStateListener(client, masterStateChanged, circuitBreaker);
    }

    @Override
    public void clear() {
        this.doNotProxyContainer.clear();
        this.mainContainer.clear();
    }

    @Override
    public int size() {
        return this.mainContainer.size() + this.doNotProxyContainer.size();
    }

    @Override
    public void forEach(Consumer<ConnectionStateListener> function) {
        this.doNotProxyContainer.forEach(function);
        function.accept(this.masterListener);
    }

    @Override
    public void addListener(ConnectionStateListener listener) {
        if (listener.doNotProxy()) {
            this.doNotProxyContainer.addListener(listener);
        } else {
            this.mainContainer.addListener(listener);
        }
    }

    @Override
    public void addListener(ConnectionStateListener listener, Executor executor) {
        if (listener.doNotProxy()) {
            this.doNotProxyContainer.addListener(listener, executor);
        } else {
            this.mainContainer.addListener(listener, executor);
        }
    }

    @Override
    public void removeListener(ConnectionStateListener listener) {
        this.mainContainer.removeListener(listener);
        this.doNotProxyContainer.removeListener(listener);
    }
}

