/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.GwtCompatible;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.GwtIncompatible;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableSet;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.IndexedImmutableSet;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.UnmodifiableIterator;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.j2objc.annotations.Weak;
import java.io.Serializable;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
final class ImmutableMapKeySet<K, V>
extends IndexedImmutableSet<K> {
    @Weak
    private final ImmutableMap<K, V> map;

    ImmutableMapKeySet(ImmutableMap<K, V> map2) {
        this.map = map2;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<K> iterator() {
        return this.map.keyIterator();
    }

    @Override
    public Spliterator<K> spliterator() {
        return this.map.keySpliterator();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.map.containsKey(object);
    }

    @Override
    K get(int index2) {
        return ((Map.Entry)((ImmutableSet)this.map.entrySet()).asList().get(index2)).getKey();
    }

    @Override
    public void forEach(Consumer<? super K> action2) {
        Preconditions.checkNotNull(action2);
        this.map.forEach((? super K k, ? super V v) -> action2.accept((Object)k));
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new KeySetSerializedForm<K>(this.map);
    }

    @GwtIncompatible
    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;
        private static final long serialVersionUID = 0L;

        KeySetSerializedForm(ImmutableMap<K, ?> map2) {
            this.map = map2;
        }

        Object readResolve() {
            return this.map.keySet();
        }
    }
}

