/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.GwtCompatible;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.GwtIncompatible;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.CollectSpliterators;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableAsList;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableCollection;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableSet;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Iterators;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.UnmodifiableIterator;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.j2objc.annotations.Weak;
import java.io.Serializable;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    @Weak
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map2) {
        this.map = map2;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<V> iterator() {
        return new UnmodifiableIterator<V>(){
            final UnmodifiableIterator<Map.Entry<K, V>> entryItr;
            {
                this.entryItr = ((ImmutableSet)ImmutableMapValues.this.map.entrySet()).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryItr.hasNext();
            }

            @Override
            public V next() {
                return ((Map.Entry)this.entryItr.next()).getValue();
            }
        };
    }

    @Override
    public Spliterator<V> spliterator() {
        return CollectSpliterators.map(((ImmutableCollection)((Object)this.map.entrySet())).spliterator(), Map.Entry::getValue);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return object != null && Iterators.contains(this.iterator(), object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    public ImmutableList<V> asList() {
        final ImmutableList entryList = ((ImmutableSet)this.map.entrySet()).asList();
        return new ImmutableAsList<V>(){

            @Override
            public V get(int index2) {
                return ((Map.Entry)entryList.get(index2)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return ImmutableMapValues.this;
            }
        };
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super V> action2) {
        Preconditions.checkNotNull(action2);
        this.map.forEach((? super K k, ? super V v) -> action2.accept((Object)v));
    }

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new SerializedForm<V>(this.map);
    }

    @GwtIncompatible
    private static class SerializedForm<V>
    implements Serializable {
        final ImmutableMap<?, V> map;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, V> map2) {
            this.map = map2;
        }

        Object readResolve() {
            return this.map.values();
        }
    }
}

