/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.GwtCompatible;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.GwtIncompatible;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.CollectPreconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Hashing;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableCollection;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMapEntry;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMapEntrySet;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableSet;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.IndexedImmutableSet;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.JdkBackedImmutableMap;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.j2objc.annotations.Weak;
import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap(ImmutableMap.EMPTY_ENTRY_ARRAY, null, 0);
    @VisibleForTesting
    static final double MAX_LOAD_FACTOR = 1.2;
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    @VisibleForTesting
    static final int MAX_HASH_BUCKET_LENGTH = 8;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    private final transient ImmutableMapEntry<K, V>[] table;
    private final transient int mask;
    private static final long serialVersionUID = 0L;

    static <K, V> ImmutableMap<K, V> fromEntries(Map.Entry<K, V> ... entries) {
        return RegularImmutableMap.fromEntryArray(entries.length, entries);
    }

    static <K, V> ImmutableMap<K, V> fromEntryArray(int n, Map.Entry<K, V>[] entryArray) {
        Preconditions.checkPositionIndex(n, entryArray.length);
        if (n == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        Map.Entry<K, V>[] entries = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int tableSize = Hashing.closedTableSize(n, 1.2);
        ImmutableMapEntry<K, V>[] table2 = ImmutableMapEntry.createEntryArray(tableSize);
        int mask = tableSize - 1;
        for (int entryIndex = 0; entryIndex < n; ++entryIndex) {
            Map.Entry<K, V> entry = entryArray[entryIndex];
            K key2 = entry.getKey();
            V value = entry.getValue();
            CollectPreconditions.checkEntryNotNull(key2, value);
            int tableIndex = Hashing.smear(key2.hashCode()) & mask;
            ImmutableMapEntry existing = table2[tableIndex];
            ImmutableMapEntry newEntry = existing == null ? RegularImmutableMap.makeImmutable(entry, key2, value) : new ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>(key2, value, existing);
            table2[tableIndex] = newEntry;
            entries[entryIndex] = newEntry;
            int bucketSize = RegularImmutableMap.checkNoConflictInKeyBucket(key2, newEntry, existing);
            if (bucketSize <= 8) continue;
            return JdkBackedImmutableMap.create(n, entryArray);
        }
        return new RegularImmutableMap<K, V>(entries, table2, mask);
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry, K key2, V value) {
        boolean reusable = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
        return reusable ? (ImmutableMapEntry)entry : new ImmutableMapEntry<K, V>(key2, value);
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry) {
        return RegularImmutableMap.makeImmutable(entry, entry.getKey(), entry.getValue());
    }

    private RegularImmutableMap(Map.Entry<K, V>[] entries, ImmutableMapEntry<K, V>[] table2, int mask) {
        this.entries = entries;
        this.table = table2;
        this.mask = mask;
    }

    @CanIgnoreReturnValue
    static int checkNoConflictInKeyBucket(Object key2, Map.Entry<?, ?> entry, @Nullable ImmutableMapEntry<?, ?> keyBucketHead) {
        int bucketSize = 0;
        while (keyBucketHead != null) {
            RegularImmutableMap.checkNoConflict(!key2.equals(keyBucketHead.getKey()), "key", entry, keyBucketHead);
            ++bucketSize;
            keyBucketHead = keyBucketHead.getNextInKeyBucket();
        }
        return bucketSize;
    }

    @Override
    public V get(@Nullable Object key2) {
        return RegularImmutableMap.get(key2, this.table, this.mask);
    }

    static <V> @Nullable V get(@Nullable Object key2, ImmutableMapEntry<?, V> @Nullable [] keyTable, int mask) {
        if (key2 == null || keyTable == null) {
            return null;
        }
        int index2 = Hashing.smear(key2.hashCode()) & mask;
        for (ImmutableMapEntry<?, V> entry = keyTable[index2]; entry != null; entry = entry.getNextInKeyBucket()) {
            Object candidateKey = entry.getKey();
            if (!key2.equals(candidateKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action2) {
        Preconditions.checkNotNull(action2);
        for (Map.Entry<K, V> entry : this.entries) {
            action2.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new KeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    @GwtCompatible(emulated=true)
    private static final class Values<K, V>
    extends ImmutableList<V> {
        @Weak
        final RegularImmutableMap<K, V> map;

        Values(RegularImmutableMap<K, V> map2) {
            this.map = map2;
        }

        @Override
        public V get(int index2) {
            return this.map.entries[index2].getValue();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        @GwtIncompatible
        Object writeReplace() {
            return new SerializedForm<V>(this.map);
        }

        @GwtIncompatible
        private static class SerializedForm<V>
        implements Serializable {
            final ImmutableMap<?, V> map;
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<?, V> map2) {
                this.map = map2;
            }

            Object readResolve() {
                return this.map.values();
            }
        }
    }

    @GwtCompatible(emulated=true)
    private static final class KeySet<K, V>
    extends IndexedImmutableSet<K> {
        @Weak
        private final RegularImmutableMap<K, V> map;

        KeySet(RegularImmutableMap<K, V> map2) {
            this.map = map2;
        }

        @Override
        K get(int index2) {
            return this.map.entries[index2].getKey();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        @GwtIncompatible
        Object writeReplace() {
            return new SerializedForm<K>(this.map);
        }

        @GwtIncompatible
        private static class SerializedForm<K>
        implements Serializable {
            final ImmutableMap<K, ?> map;
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<K, ?> map2) {
                this.map = map2;
            }

            Object readResolve() {
                return this.map.keySet();
            }
        }
    }
}

