/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Function;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Maps;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.AbstractBaseGraph;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.AbstractGraph;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.ElementOrder;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.EndpointPair;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.Graph;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.ValueGraph;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
public abstract class AbstractValueGraph<N, V>
extends AbstractBaseGraph<N>
implements ValueGraph<N, V> {
    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(){

            @Override
            public Set<N> nodes() {
                return AbstractValueGraph.this.nodes();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                return AbstractValueGraph.this.edges();
            }

            @Override
            public boolean isDirected() {
                return AbstractValueGraph.this.isDirected();
            }

            @Override
            public boolean allowsSelfLoops() {
                return AbstractValueGraph.this.allowsSelfLoops();
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return AbstractValueGraph.this.nodeOrder();
            }

            @Override
            public Set<N> adjacentNodes(N node2) {
                return AbstractValueGraph.this.adjacentNodes(node2);
            }

            @Override
            public Set<N> predecessors(N node2) {
                return AbstractValueGraph.this.predecessors(node2);
            }

            @Override
            public Set<N> successors(N node2) {
                return AbstractValueGraph.this.successors(node2);
            }

            @Override
            public int degree(N node2) {
                return AbstractValueGraph.this.degree(node2);
            }

            @Override
            public int inDegree(N node2) {
                return AbstractValueGraph.this.inDegree(node2);
            }

            @Override
            public int outDegree(N node2) {
                return AbstractValueGraph.this.outDegree(node2);
            }
        };
    }

    @Override
    public Optional<V> edgeValue(N nodeU, N nodeV) {
        return Optional.ofNullable(this.edgeValueOrDefault(nodeU, nodeV, null));
    }

    @Override
    public final boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueGraph)) {
            return false;
        }
        ValueGraph other = (ValueGraph)obj;
        return this.isDirected() == other.isDirected() && this.nodes().equals(other.nodes()) && AbstractValueGraph.edgeValueMap(this).equals(AbstractValueGraph.edgeValueMap(other));
    }

    @Override
    public final int hashCode() {
        return AbstractValueGraph.edgeValueMap(this).hashCode();
    }

    public String toString() {
        return "isDirected: " + this.isDirected() + ", allowsSelfLoops: " + this.allowsSelfLoops() + ", nodes: " + this.nodes() + ", edges: " + AbstractValueGraph.edgeValueMap(this);
    }

    private static <N, V> Map<EndpointPair<N>, V> edgeValueMap(final ValueGraph<N, V> graph2) {
        Function edgeToValueFn = new Function<EndpointPair<N>, V>(){

            @Override
            public V apply(EndpointPair<N> edge) {
                return graph2.edgeValueOrDefault(edge.nodeU(), edge.nodeV(), null);
            }
        };
        return Maps.asMap(graph2.edges(), edgeToValueFn);
    }
}

