/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Function;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Maps;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.ConfigurableNetwork;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.DirectedMultiNetworkConnections;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.DirectedNetworkConnections;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.ImmutableGraph;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.Network;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.NetworkBuilder;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.NetworkConnections;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.UndirectedMultiNetworkConnections;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.UndirectedNetworkConnections;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.errorprone.annotations.Immutable;
import java.util.Map;

@Immutable(containerOf={"N", "E"})
@Beta
public final class ImmutableNetwork<N, E>
extends ConfigurableNetwork<N, E> {
    private ImmutableNetwork(Network<N, E> network) {
        super(NetworkBuilder.from(network), ImmutableNetwork.getNodeConnections(network), ImmutableNetwork.getEdgeToReferenceNode(network));
    }

    public static <N, E> ImmutableNetwork<N, E> copyOf(Network<N, E> network) {
        return network instanceof ImmutableNetwork ? (ImmutableNetwork<N, E>)network : new ImmutableNetwork<N, E>(network);
    }

    @Deprecated
    public static <N, E> ImmutableNetwork<N, E> copyOf(ImmutableNetwork<N, E> network) {
        return Preconditions.checkNotNull(network);
    }

    @Override
    public ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(super.asGraph());
    }

    private static <N, E> Map<N, NetworkConnections<N, E>> getNodeConnections(Network<N, E> network) {
        ImmutableMap.Builder<N, NetworkConnections<N, E>> nodeConnections = ImmutableMap.builder();
        for (N node2 : network.nodes()) {
            nodeConnections.put(node2, ImmutableNetwork.connectionsOf(network, node2));
        }
        return nodeConnections.build();
    }

    private static <N, E> Map<E, N> getEdgeToReferenceNode(Network<N, E> network) {
        ImmutableMap.Builder<E, N> edgeToReferenceNode = ImmutableMap.builder();
        for (E edge : network.edges()) {
            edgeToReferenceNode.put(edge, network.incidentNodes(edge).nodeU());
        }
        return edgeToReferenceNode.build();
    }

    private static <N, E> NetworkConnections<N, E> connectionsOf(Network<N, E> network, N node2) {
        if (network.isDirected()) {
            Map<E, N> inEdgeMap = Maps.asMap(network.inEdges(node2), ImmutableNetwork.sourceNodeFn(network));
            Map<E, N> outEdgeMap = Maps.asMap(network.outEdges(node2), ImmutableNetwork.targetNodeFn(network));
            int selfLoopCount = network.edgesConnecting(node2, node2).size();
            return network.allowsParallelEdges() ? DirectedMultiNetworkConnections.ofImmutable(inEdgeMap, outEdgeMap, selfLoopCount) : DirectedNetworkConnections.ofImmutable(inEdgeMap, outEdgeMap, selfLoopCount);
        }
        Map<E, N> incidentEdgeMap = Maps.asMap(network.incidentEdges(node2), ImmutableNetwork.adjacentNodeFn(network, node2));
        return network.allowsParallelEdges() ? UndirectedMultiNetworkConnections.ofImmutable(incidentEdgeMap) : UndirectedNetworkConnections.ofImmutable(incidentEdgeMap);
    }

    private static <N, E> Function<E, N> sourceNodeFn(final Network<N, E> network) {
        return new Function<E, N>(){

            @Override
            public N apply(E edge) {
                return network.incidentNodes(edge).source();
            }
        };
    }

    private static <N, E> Function<E, N> targetNodeFn(final Network<N, E> network) {
        return new Function<E, N>(){

            @Override
            public N apply(E edge) {
                return network.incidentNodes(edge).target();
            }
        };
    }

    private static <N, E> Function<E, N> adjacentNodeFn(final Network<N, E> network, final N node2) {
        return new Function<E, N>(){

            @Override
            public N apply(E edge) {
                return network.incidentNodes(edge).adjacentNode(node2);
            }
        };
    }
}

