/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.primitives;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.GwtCompatible;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.Comparator;

@GwtCompatible
public final class SignedBytes {
    public static final byte MAX_POWER_OF_TWO = 64;

    private SignedBytes() {
    }

    public static byte checkedCast(long value) {
        byte result = (byte)value;
        Preconditions.checkArgument((long)result == value, "Out of range: %s", value);
        return result;
    }

    public static byte saturatedCast(long value) {
        if (value > 127L) {
            return 127;
        }
        if (value < -128L) {
            return -128;
        }
        return (byte)value;
    }

    public static int compare(byte a, byte b) {
        return a - b;
    }

    public static byte min(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        byte min2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] >= min2) continue;
            min2 = array2[i];
        }
        return min2;
    }

    public static byte max(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        byte max2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] <= max2) continue;
            max2 = array2[i];
        }
        return max2;
    }

    public static String join(String separator, byte ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(array2[i]);
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(byte[] array2) {
        Preconditions.checkNotNull(array2);
        SignedBytes.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(byte[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        Arrays.sort(array2, fromIndex, toIndex);
        Bytes.reverse(array2, fromIndex, toIndex);
    }

    private static enum LexicographicalComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        public int compare(byte[] left2, byte[] right2) {
            int minLength = Math.min(left2.length, right2.length);
            for (int i = 0; i < minLength; ++i) {
                int result = SignedBytes.compare(left2[i], right2[i]);
                if (result == 0) continue;
                return result;
            }
            return left2.length - right2.length;
        }

        public String toString() {
            return "SignedBytes.lexicographicalComparator()";
        }
    }
}

