/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper;

import io.mantisrx.shaded.jline.console.completer.Completer;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.ZooKeeper;
import io.mantisrx.shaded.org.apache.zookeeper.ZooKeeperMain;
import java.util.Collections;
import java.util.List;

class JLineZNodeCompleter
implements Completer {
    private ZooKeeper zk;

    public JLineZNodeCompleter(ZooKeeper zk) {
        this.zk = zk;
    }

    public int complete(String buffer, int cursor, List candidates) {
        String[] tokens;
        buffer = buffer.substring(0, cursor);
        String token = "";
        if (!buffer.endsWith(" ") && (tokens = buffer.split(" ")).length != 0) {
            token = tokens[tokens.length - 1];
        }
        if (token.startsWith("/")) {
            return this.completeZNode(buffer, token, candidates);
        }
        return this.completeCommand(buffer, token, candidates);
    }

    private int completeCommand(String buffer, String token, List<String> candidates) {
        for (String cmd : ZooKeeperMain.getCommands()) {
            if (!cmd.startsWith(token)) continue;
            candidates.add(cmd);
        }
        return buffer.lastIndexOf(" ") + 1;
    }

    private int completeZNode(String buffer, String token, List<String> candidates) {
        String path2 = token;
        int idx = path2.lastIndexOf("/") + 1;
        String prefix = path2.substring(idx);
        try {
            String dir2 = idx == 1 ? "/" : path2.substring(0, idx - 1);
            List<String> children2 = this.zk.getChildren(dir2, false);
            for (String child : children2) {
                if (!child.startsWith(prefix)) continue;
                candidates.add(child);
            }
        }
        catch (InterruptedException e2) {
            return 0;
        }
        catch (KeeperException e3) {
            return 0;
        }
        Collections.sort(candidates);
        return candidates.size() == 0 ? buffer.length() : buffer.lastIndexOf("/") + 1;
    }
}

