/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper;

import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.Op;
import io.mantisrx.shaded.org.apache.zookeeper.ZooKeeper;
import io.mantisrx.shaded.org.apache.zookeeper.common.PathUtils;
import io.mantisrx.shaded.org.apache.zookeeper.data.ACL;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtil.class);
    private static final Map<Integer, String> permCache = new ConcurrentHashMap<Integer, String>();

    public static boolean deleteRecursive(ZooKeeper zk, String pathRoot, int batchSize) throws InterruptedException, KeeperException {
        PathUtils.validatePath(pathRoot);
        List<String> tree = ZKUtil.listSubTreeBFS(zk, pathRoot);
        LOG.debug("Deleting tree: {}", (Object)tree);
        return ZKUtil.deleteInBatch(zk, tree, batchSize);
    }

    private static boolean deleteInBatch(ZooKeeper zk, List<String> tree, int batchSize) throws InterruptedException {
        int rateLimit = 10;
        ArrayList<Op> ops = new ArrayList<Op>();
        BatchedDeleteCbContext context = new BatchedDeleteCbContext(rateLimit);
        AsyncCallback.MultiCallback cb = (rc, path2, ctx, opResults) -> {
            ((BatchedDeleteCbContext)ctx).sem.release();
            if (rc != KeeperException.Code.OK.intValue()) {
                ((BatchedDeleteCbContext)ctx).success.set(false);
            }
        };
        for (int i = tree.size() - 1; i >= 0; --i) {
            ops.add(Op.delete(tree.get(i), -1));
            if (ops.size() != batchSize && i != 0) continue;
            if (!context.success.get()) break;
            context.sem.acquire();
            zk.multi(ops, cb, context);
            ops = new ArrayList();
        }
        context.sem.acquire(rateLimit);
        return context.success.get();
    }

    public static void deleteRecursive(ZooKeeper zk, String pathRoot, AsyncCallback.VoidCallback cb, Object ctx) throws InterruptedException, KeeperException {
        PathUtils.validatePath(pathRoot);
        List<String> tree = ZKUtil.listSubTreeBFS(zk, pathRoot);
        LOG.debug("Deleting tree: {}", (Object)tree);
        for (int i = tree.size() - 1; i >= 0; --i) {
            zk.delete(tree.get(i), -1, cb, ctx);
        }
    }

    public static String validateFileInput(String filePath) {
        File file2 = new File(filePath);
        if (!file2.exists()) {
            return "File '" + file2.getAbsolutePath() + "' does not exist.";
        }
        if (!file2.canRead()) {
            return "Read permission is denied on the file '" + file2.getAbsolutePath() + "'";
        }
        if (file2.isDirectory()) {
            return "'" + file2.getAbsolutePath() + "' is a direcory. it must be a file.";
        }
        return null;
    }

    public static List<String> listSubTreeBFS(ZooKeeper zk, String pathRoot) throws KeeperException, InterruptedException {
        ArrayDeque<String> queue = new ArrayDeque<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(pathRoot);
        tree.add(pathRoot);
        while (!queue.isEmpty()) {
            String node2 = (String)queue.poll();
            List<String> children2 = zk.getChildren(node2, false);
            for (String child : children2) {
                String childPath = node2 + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    public static void visitSubTreeDFS(ZooKeeper zk, String path2, boolean watch, AsyncCallback.StringCallback cb) throws KeeperException, InterruptedException {
        PathUtils.validatePath(path2);
        zk.getData(path2, watch, null);
        cb.processResult(KeeperException.Code.OK.intValue(), path2, null, path2);
        ZKUtil.visitSubTreeDFSHelper(zk, path2, watch, cb);
    }

    private static void visitSubTreeDFSHelper(ZooKeeper zk, String path2, boolean watch, AsyncCallback.StringCallback cb) throws KeeperException, InterruptedException {
        boolean isRoot = path2.length() == 1;
        try {
            String childPath;
            List<String> children2 = zk.getChildren(path2, watch, null);
            Collections.sort(children2);
            for (String child : children2) {
                childPath = (isRoot ? path2 : path2 + "/") + child;
                cb.processResult(KeeperException.Code.OK.intValue(), childPath, null, child);
            }
            for (String child : children2) {
                childPath = (isRoot ? path2 : path2 + "/") + child;
                ZKUtil.visitSubTreeDFSHelper(zk, childPath, watch, cb);
            }
        }
        catch (KeeperException.NoNodeException e2) {
            return;
        }
    }

    public static String getPermString(int perms) {
        return permCache.computeIfAbsent(perms, k -> ZKUtil.constructPermString(k));
    }

    private static String constructPermString(int perms) {
        StringBuilder p = new StringBuilder();
        if ((perms & 4) != 0) {
            p.append('c');
        }
        if ((perms & 8) != 0) {
            p.append('d');
        }
        if ((perms & 1) != 0) {
            p.append('r');
        }
        if ((perms & 2) != 0) {
            p.append('w');
        }
        if ((perms & 0x10) != 0) {
            p.append('a');
        }
        return p.toString();
    }

    public static String aclToString(List<ACL> acls) {
        StringBuilder sb = new StringBuilder();
        for (ACL acl : acls) {
            sb.append(acl.getId().getScheme());
            sb.append(":");
            sb.append(acl.getId().getId());
            sb.append(":");
            sb.append(ZKUtil.getPermString(acl.getPerms()));
        }
        return sb.toString();
    }

    private static class BatchedDeleteCbContext {
        public Semaphore sem;
        public AtomicBoolean success;

        public BatchedDeleteCbContext(int rateLimit) {
            this.sem = new Semaphore(rateLimit);
            this.success = new AtomicBoolean(true);
        }
    }
}

