/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.cli;

import io.mantisrx.shaded.org.apache.zookeeper.AddWatchMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliCommand;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliParseException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliWrapperException;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class AddWatchCommand
extends CliCommand {
    private static final Options options = new Options();
    private static final AddWatchMode defaultMode = AddWatchMode.PERSISTENT_RECURSIVE;
    private CommandLine cl;
    private AddWatchMode mode = defaultMode;

    public AddWatchCommand() {
        super("addWatch", "[-m mode] path # optional mode is one of " + Arrays.toString((Object[])AddWatchMode.values()) + " - default is " + defaultMode.name());
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser2 = new PosixParser();
        try {
            this.cl = parser2.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        if (this.cl.getArgs().length != 2) {
            throw new CliParseException(this.getUsageStr());
        }
        if (this.cl.hasOption("m")) {
            try {
                this.mode = AddWatchMode.valueOf(this.cl.getOptionValue("m").toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                throw new CliParseException(this.getUsageStr());
            }
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path2 = this.cl.getArgs()[1];
        try {
            this.zk.addWatch(path2, this.mode);
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    static {
        options.addOption("m", true, "");
    }
}

