/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.cli;

import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.ZKUtil;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliCommand;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliParseException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliWrapperException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.MalformedCommandException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.MalformedPathException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class DeleteAllCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public DeleteAllCommand() {
        this("deleteall");
    }

    public DeleteAllCommand(String cmdStr) {
        super(cmdStr, "path [-b batch size]");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser2 = new PosixParser();
        try {
            this.cl = parser2.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        int batchSize;
        try {
            batchSize = this.cl.hasOption("b") ? Integer.parseInt(this.cl.getOptionValue("b")) : 1000;
        }
        catch (NumberFormatException e2) {
            throw new MalformedCommandException("-b argument must be an int value");
        }
        String path2 = this.args[1];
        try {
            boolean success2 = ZKUtil.deleteRecursive(this.zk, path2, batchSize);
            if (!success2) {
                this.err.println("Failed to delete some node(s) in the subtree!");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    static {
        options.addOption(new Option("b", true, "batch size"));
    }
}

