/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.cli;

import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliCommand;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliParseException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.MalformedPathException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.StatPrinter;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class GetCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetCommand() {
        super("get", "[-s] [-w] path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser2 = new PosixParser();
        try {
            this.cl = parser2.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        this.retainCompatibility(cmdArgs);
        return this;
    }

    private void retainCompatibility(String[] cmdArgs) throws CliParseException {
        if (this.args.length > 2) {
            cmdArgs[2] = "-w";
            this.err.println("'get path [watch]' has been deprecated. Please use 'get [-s] [-w] path' instead.");
            PosixParser parser2 = new PosixParser();
            try {
                this.cl = parser2.parse(options, cmdArgs);
            }
            catch (ParseException ex) {
                throw new CliParseException(ex);
            }
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws CliException {
        byte[] data2;
        boolean watch = this.cl.hasOption("w");
        String path2 = this.args[1];
        Stat stat = new Stat();
        try {
            data2 = this.zk.getData(path2, watch, stat);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliException(ex);
        }
        data2 = data2 == null ? "null".getBytes() : data2;
        this.out.println(new String(data2));
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return watch;
    }

    static {
        options.addOption("s", false, "stats");
        options.addOption("w", false, "watch");
    }
}

