/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.cli;

import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.StatsTrack;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliCommand;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliParseException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliWrapperException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.MalformedPathException;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ListQuotaCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public ListQuotaCommand() {
        super("listquota", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        PosixParser parser2 = new PosixParser();
        try {
            cl = parser2.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path2 = this.args[1];
        String absolutePath = "/zookeeper/quota" + path2 + "/" + "zookeeper_limits";
        try {
            this.err.println("absolute path is " + absolutePath);
            Stat stat = new Stat();
            byte[] data2 = this.zk.getData(absolutePath, false, stat);
            StatsTrack st = new StatsTrack(new String(data2));
            this.out.println("Output quota for " + path2 + " " + st.toString());
            data2 = this.zk.getData("/zookeeper/quota" + path2 + "/" + "zookeeper_stats", false, stat);
            this.out.println("Output stat for " + path2 + " " + new StatsTrack(new String(data2)).toString());
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException.NoNodeException ne) {
            this.err.println("quota for " + path2 + " does not exist.");
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }
}

