/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.jmx;

import io.mantisrx.shaded.org.apache.zookeeper.jmx.ZKMBeanInfo;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanRegistry {
    public static final String DOMAIN = "org.apache.ZooKeeperService";
    private static final Logger LOG = LoggerFactory.getLogger(MBeanRegistry.class);
    private static volatile MBeanRegistry instance = new MBeanRegistry();
    private final Object LOCK = new Object();
    private Map<ZKMBeanInfo, String> mapBean2Path = new ConcurrentHashMap<ZKMBeanInfo, String>();
    private MBeanServer mBeanServer;

    public static void setInstance(MBeanRegistry instance) {
        MBeanRegistry.instance = instance;
    }

    public static MBeanRegistry getInstance() {
        return instance;
    }

    public MBeanRegistry() {
        try {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Error e2) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
        }
    }

    public MBeanServer getPlatformMBeanServer() {
        return this.mBeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ZKMBeanInfo bean2, ZKMBeanInfo parent) throws JMException {
        assert (bean2 != null);
        String path2 = null;
        if (parent != null) {
            path2 = this.mapBean2Path.get(parent);
            assert (path2 != null);
        }
        path2 = this.makeFullPath(path2, parent);
        if (bean2.isHidden()) {
            return;
        }
        ObjectName oname = this.makeObjectName(path2, bean2);
        try {
            Object object = this.LOCK;
            synchronized (object) {
                this.mBeanServer.registerMBean(bean2, oname);
                this.mapBean2Path.put(bean2, path2);
            }
        }
        catch (JMException e2) {
            LOG.warn("Failed to register MBean {}", (Object)bean2.getName());
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(String path2, ZKMBeanInfo bean2) throws JMException {
        if (path2 == null) {
            return;
        }
        if (!bean2.isHidden()) {
            ObjectName objName = this.makeObjectName(path2, bean2);
            LOG.debug("Unregister MBean [{}]", (Object)objName);
            Object object = this.LOCK;
            synchronized (object) {
                this.mBeanServer.unregisterMBean(objName);
            }
        }
    }

    public Set<ZKMBeanInfo> getRegisteredBeans() {
        return new HashSet<ZKMBeanInfo>(this.mapBean2Path.keySet());
    }

    public void unregister(ZKMBeanInfo bean2) {
        if (bean2 == null) {
            return;
        }
        String path2 = this.mapBean2Path.remove(bean2);
        try {
            this.unregister(path2, bean2);
        }
        catch (JMException e2) {
            LOG.warn("Error during unregister of [{}]", (Object)bean2.getName(), (Object)e2);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception during unregister of [{}]. It should be reviewed and fixed.", (Object)bean2.getName(), (Object)t);
        }
    }

    public String makeFullPath(String prefix, String ... name2) {
        StringBuilder sb = new StringBuilder(prefix == null ? "/" : (prefix.equals("/") ? prefix : prefix + "/"));
        boolean first2 = true;
        for (String s : name2) {
            if (s == null) continue;
            if (!first2) {
                sb.append("/");
            } else {
                first2 = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    protected String makeFullPath(String prefix, ZKMBeanInfo bean2) {
        return this.makeFullPath(prefix, bean2 == null ? null : bean2.getName());
    }

    private int tokenize(StringBuilder sb, String path2, int index2) {
        String[] tokens;
        for (String s : tokens = path2.split("/")) {
            if (s.length() == 0) continue;
            sb.append("name").append(index2++).append("=").append(s).append(",");
        }
        return index2;
    }

    protected ObjectName makeObjectName(String path2, ZKMBeanInfo bean2) throws MalformedObjectNameException {
        if (path2 == null) {
            return null;
        }
        StringBuilder beanName = new StringBuilder("org.apache.ZooKeeperService:");
        int counter = 0;
        counter = this.tokenize(beanName, path2, counter);
        this.tokenize(beanName, bean2.getName(), counter);
        beanName.deleteCharAt(beanName.length() - 1);
        try {
            return new ObjectName(beanName.toString());
        }
        catch (MalformedObjectNameException e2) {
            LOG.warn("Invalid name \"{}\" for class {}", (Object)beanName, (Object)bean2.getClass());
            throw e2;
        }
    }
}

