/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.zookeeper.common.Time;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataNode;
import io.mantisrx.shaded.org.apache.zookeeper.server.EphemeralType;
import io.mantisrx.shaded.org.apache.zookeeper.server.Request;
import io.mantisrx.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZKDatabase;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManager {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerManager.class);
    private final ZKDatabase zkDb;
    private final RequestProcessor requestProcessor;
    private final int checkIntervalMs;
    private final int maxPerMinute;
    private final long maxNeverUsedIntervalMs;
    private final Timer timer;
    private final AtomicReference<TimerTask> task = new AtomicReference<Object>(null);

    public ContainerManager(ZKDatabase zkDb, RequestProcessor requestProcessor, int checkIntervalMs, int maxPerMinute) {
        this(zkDb, requestProcessor, checkIntervalMs, maxPerMinute, 0L);
    }

    public ContainerManager(ZKDatabase zkDb, RequestProcessor requestProcessor, int checkIntervalMs, int maxPerMinute, long maxNeverUsedIntervalMs) {
        this.zkDb = zkDb;
        this.requestProcessor = requestProcessor;
        this.checkIntervalMs = checkIntervalMs;
        this.maxPerMinute = maxPerMinute;
        this.maxNeverUsedIntervalMs = maxNeverUsedIntervalMs;
        this.timer = new Timer("ContainerManagerTask", true);
        LOG.info("Using checkIntervalMs={} maxPerMinute={} maxNeverUsedIntervalMs={}", checkIntervalMs, maxPerMinute, maxNeverUsedIntervalMs);
    }

    public void start() {
        TimerTask timerTask;
        if (this.task.get() == null && this.task.compareAndSet(null, timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ContainerManager.this.checkContainers();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    LOG.info("interrupted");
                    this.cancel();
                }
                catch (Throwable e3) {
                    LOG.error("Error checking containers", e3);
                }
            }
        })) {
            this.timer.scheduleAtFixedRate(timerTask, this.checkIntervalMs, (long)this.checkIntervalMs);
        }
    }

    public void stop() {
        TimerTask timerTask = this.task.getAndSet(null);
        if (timerTask != null) {
            timerTask.cancel();
        }
        this.timer.cancel();
    }

    public void checkContainers() throws InterruptedException {
        long minIntervalMs = this.getMinIntervalMs();
        for (String containerPath : this.getCandidates()) {
            long elapsedMs;
            long waitMs;
            long startMs = Time.currentElapsedTime();
            ByteBuffer path2 = ByteBuffer.wrap(containerPath.getBytes());
            Request request = new Request(null, 0L, 0, 20, path2, null);
            try {
                LOG.info("Attempting to delete candidate container: {}", (Object)containerPath);
                this.postDeleteRequest(request);
            }
            catch (Exception e2) {
                LOG.error("Could not delete container: {}", (Object)containerPath, (Object)e2);
            }
            if ((waitMs = minIntervalMs - (elapsedMs = Time.currentElapsedTime() - startMs)) <= 0L) continue;
            Thread.sleep(waitMs);
        }
    }

    protected void postDeleteRequest(Request request) throws RequestProcessor.RequestProcessorException {
        this.requestProcessor.processRequest(request);
    }

    protected long getMinIntervalMs() {
        return TimeUnit.MINUTES.toMillis(1L) / (long)this.maxPerMinute;
    }

    protected Collection<String> getCandidates() {
        DataNode node2;
        HashSet<String> candidates = new HashSet<String>();
        for (String containerPath : this.zkDb.getDataTree().getContainers()) {
            node2 = this.zkDb.getDataTree().getNode(containerPath);
            if (node2 != null && node2.getChildren().isEmpty()) {
                if (node2.stat.getCversion() > 0) {
                    candidates.add(containerPath);
                } else if (this.maxNeverUsedIntervalMs != 0L && this.getElapsed(node2) > this.maxNeverUsedIntervalMs) {
                    candidates.add(containerPath);
                }
            }
            if (node2 == null || node2.stat.getCversion() <= 0 || !node2.getChildren().isEmpty()) continue;
            candidates.add(containerPath);
        }
        for (String ttlPath : this.zkDb.getDataTree().getTtls()) {
            long ttl;
            Set<String> children2;
            node2 = this.zkDb.getDataTree().getNode(ttlPath);
            if (node2 == null || !(children2 = node2.getChildren()).isEmpty() || EphemeralType.get(node2.stat.getEphemeralOwner()) != EphemeralType.TTL || (ttl = EphemeralType.TTL.getValue(node2.stat.getEphemeralOwner())) == 0L || this.getElapsed(node2) <= ttl) continue;
            candidates.add(ttlPath);
        }
        return candidates;
    }

    protected long getElapsed(DataNode node2) {
        return Time.currentWallTime() - node2.stat.getMtime();
    }
}

