/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.jute.Record;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.MultiOperationRecord;
import io.mantisrx.shaded.org.apache.zookeeper.MultiResponse;
import io.mantisrx.shaded.org.apache.zookeeper.Op;
import io.mantisrx.shaded.org.apache.zookeeper.OpResult;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import io.mantisrx.shaded.org.apache.zookeeper.audit.AuditHelper;
import io.mantisrx.shaded.org.apache.zookeeper.common.Time;
import io.mantisrx.shaded.org.apache.zookeeper.data.ACL;
import io.mantisrx.shaded.org.apache.zookeeper.data.Id;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import io.mantisrx.shaded.org.apache.zookeeper.proto.AddWatchRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.CheckWatchesRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.Create2Response;
import io.mantisrx.shaded.org.apache.zookeeper.proto.CreateResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.ErrorResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.ExistsRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.ExistsResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetACLRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetACLResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetAllChildrenNumberRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetAllChildrenNumberResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetChildren2Request;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetChildren2Response;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetChildrenRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetChildrenResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetDataRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetDataResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetEphemeralsRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.GetEphemeralsResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.RemoveWatchesRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.ReplyHeader;
import io.mantisrx.shaded.org.apache.zookeeper.proto.SetACLResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.SetDataResponse;
import io.mantisrx.shaded.org.apache.zookeeper.proto.SetWatches;
import io.mantisrx.shaded.org.apache.zookeeper.proto.SetWatches2;
import io.mantisrx.shaded.org.apache.zookeeper.proto.SyncRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.SyncResponse;
import io.mantisrx.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataNode;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataTree;
import io.mantisrx.shaded.org.apache.zookeeper.server.Request;
import io.mantisrx.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooTrace;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.util.RequestPathMetricsCollector;
import io.mantisrx.shaded.org.apache.zookeeper.txn.ErrorTxn;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FinalRequestProcessor.class);
    private final RequestPathMetricsCollector requestPathMetricsCollector;
    ZooKeeperServer zks;

    public FinalRequestProcessor(ZooKeeperServer zks) {
        this.zks = zks;
        this.requestPathMetricsCollector = zks.getRequestPathMetricsCollector();
    }

    @Override
    public void processRequest(Request request) {
        long propagationLatency;
        LOG.debug("Processing request:: {}", (Object)request);
        long traceMask = 2L;
        if (request.type == 11) {
            traceMask = 128L;
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logRequest(LOG, traceMask, 'E', request, "");
        }
        DataTree.ProcessTxnResult rc = this.zks.processTxn(request);
        if (request.type == -11 && this.connClosedByClient(request) && (this.closeSession(this.zks.serverCnxnFactory, request.sessionId) || this.closeSession(this.zks.secureServerCnxnFactory, request.sessionId))) {
            return;
        }
        if (request.getHdr() != null && (propagationLatency = Time.currentWallTime() - request.getHdr().getTime()) >= 0L) {
            ServerMetrics.getMetrics().PROPAGATION_LATENCY.add(propagationLatency);
        }
        if (request.cnxn == null) {
            return;
        }
        ServerCnxn cnxn = request.cnxn;
        long lastZxid = this.zks.getZKDatabase().getDataTreeLastProcessedZxid();
        String lastOp = "NA";
        this.zks.decInProcess();
        this.zks.requestFinished(request);
        KeeperException.Code err = KeeperException.Code.OK;
        Record rsp = null;
        String path2 = null;
        try {
            if (request.getHdr() != null && request.getHdr().getType() == -1) {
                AuditHelper.addAuditLog(request, rc, true);
                if (request.getException() != null) {
                    throw request.getException();
                }
                throw KeeperException.create(KeeperException.Code.get(((ErrorTxn)request.getTxn()).getErr()));
            }
            KeeperException ke = request.getException();
            if (ke instanceof KeeperException.SessionMovedException) {
                throw ke;
            }
            if (ke != null && request.type != 14) {
                throw ke;
            }
            LOG.debug("{}", (Object)request);
            if (request.isStale()) {
                ServerMetrics.getMetrics().STALE_REPLIES.add(1L);
            }
            AuditHelper.addAuditLog(request, rc);
            switch (request.type) {
                case 11: {
                    lastOp = "PING";
                    this.updateStats(request, lastOp, lastZxid);
                    cnxn.sendResponse(new ReplyHeader(-2, lastZxid, 0), null, "response");
                    return;
                }
                case -10: {
                    lastOp = "SESS";
                    this.updateStats(request, lastOp, lastZxid);
                    this.zks.finishSessionInit(request.cnxn, true);
                    return;
                }
                case 14: {
                    lastOp = "MULT";
                    rsp = new MultiResponse();
                    for (DataTree.ProcessTxnResult subTxnResult : rc.multiResult) {
                        OpResult subResult;
                        switch (subTxnResult.type) {
                            case 13: {
                                subResult = new OpResult.CheckResult();
                                break;
                            }
                            case 1: {
                                subResult = new OpResult.CreateResult(subTxnResult.path);
                                break;
                            }
                            case 15: 
                            case 19: 
                            case 21: {
                                subResult = new OpResult.CreateResult(subTxnResult.path, subTxnResult.stat);
                                break;
                            }
                            case 2: 
                            case 20: {
                                subResult = new OpResult.DeleteResult();
                                break;
                            }
                            case 5: {
                                subResult = new OpResult.SetDataResult(subTxnResult.stat);
                                break;
                            }
                            case -1: {
                                subResult = new OpResult.ErrorResult(subTxnResult.err);
                                if (subTxnResult.err != KeeperException.Code.SESSIONMOVED.intValue()) break;
                                throw new KeeperException.SessionMovedException();
                            }
                            default: {
                                throw new IOException("Invalid type of op");
                            }
                        }
                        ((MultiResponse)rsp).add(subResult);
                    }
                    break;
                }
                case 22: {
                    lastOp = "MLTR";
                    MultiOperationRecord multiReadRecord = new MultiOperationRecord();
                    ByteBufferInputStream.byteBuffer2Record(request.request, multiReadRecord);
                    rsp = new MultiResponse();
                    for (Op readOp : multiReadRecord) {
                        OpResult subResult;
                        try {
                            switch (readOp.getType()) {
                                case 8: {
                                    Record rec = this.handleGetChildrenRequest(readOp.toRequestRecord(), cnxn, request.authInfo);
                                    subResult = new OpResult.GetChildrenResult(((GetChildrenResponse)rec).getChildren());
                                    break;
                                }
                                case 4: {
                                    Record rec = this.handleGetDataRequest(readOp.toRequestRecord(), cnxn, request.authInfo);
                                    GetDataResponse gdr = (GetDataResponse)rec;
                                    subResult = new OpResult.GetDataResult(gdr.getData(), gdr.getStat());
                                    break;
                                }
                                default: {
                                    throw new IOException("Invalid type of readOp");
                                }
                            }
                        }
                        catch (KeeperException e2) {
                            subResult = new OpResult.ErrorResult(e2.code().intValue());
                        }
                        ((MultiResponse)rsp).add(subResult);
                    }
                    break;
                }
                case 1: {
                    lastOp = "CREA";
                    rsp = new CreateResponse(rc.path);
                    err = KeeperException.Code.get(rc.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 15: 
                case 19: 
                case 21: {
                    lastOp = "CREA";
                    rsp = new Create2Response(rc.path, rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 2: 
                case 20: {
                    lastOp = "DELE";
                    err = KeeperException.Code.get(rc.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 5: {
                    lastOp = "SETD";
                    rsp = new SetDataResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case 16: {
                    lastOp = "RECO";
                    rsp = new GetDataResponse(((QuorumZooKeeperServer)this.zks).self.getQuorumVerifier().toString().getBytes(), rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 7: {
                    lastOp = "SETA";
                    rsp = new SetACLResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, rc.path);
                    break;
                }
                case -11: {
                    lastOp = "CLOS";
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 9: {
                    lastOp = "SYNC";
                    SyncRequest syncRequest = new SyncRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, syncRequest);
                    rsp = new SyncResponse(syncRequest.getPath());
                    this.requestPathMetricsCollector.registerRequest(request.type, syncRequest.getPath());
                    break;
                }
                case 13: {
                    lastOp = "CHEC";
                    rsp = new SetDataResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 3: {
                    lastOp = "EXIS";
                    ExistsRequest existsRequest = new ExistsRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, existsRequest);
                    path2 = existsRequest.getPath();
                    if (path2.indexOf(0) != -1) {
                        throw new KeeperException.BadArgumentsException();
                    }
                    Stat stat = this.zks.getZKDatabase().statNode(path2, existsRequest.getWatch() ? cnxn : null);
                    rsp = new ExistsResponse(stat);
                    this.requestPathMetricsCollector.registerRequest(request.type, path2);
                    break;
                }
                case 4: {
                    lastOp = "GETD";
                    GetDataRequest getDataRequest = new GetDataRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getDataRequest);
                    path2 = getDataRequest.getPath();
                    rsp = this.handleGetDataRequest(getDataRequest, cnxn, request.authInfo);
                    this.requestPathMetricsCollector.registerRequest(request.type, path2);
                    break;
                }
                case 101: {
                    lastOp = "SETW";
                    Record setWatches = new SetWatches();
                    request.request.rewind();
                    ByteBufferInputStream.byteBuffer2Record(request.request, setWatches);
                    long relativeZxid = ((SetWatches)setWatches).getRelativeZxid();
                    this.zks.getZKDatabase().setWatches(relativeZxid, ((SetWatches)setWatches).getDataWatches(), ((SetWatches)setWatches).getExistWatches(), ((SetWatches)setWatches).getChildWatches(), Collections.emptyList(), Collections.emptyList(), cnxn);
                    break;
                }
                case 105: {
                    lastOp = "STW2";
                    Record setWatches = new SetWatches2();
                    request.request.rewind();
                    ByteBufferInputStream.byteBuffer2Record(request.request, setWatches);
                    long relativeZxid = ((SetWatches2)setWatches).getRelativeZxid();
                    this.zks.getZKDatabase().setWatches(relativeZxid, ((SetWatches2)setWatches).getDataWatches(), ((SetWatches2)setWatches).getExistWatches(), ((SetWatches2)setWatches).getChildWatches(), ((SetWatches2)setWatches).getPersistentWatches(), ((SetWatches2)setWatches).getPersistentRecursiveWatches(), cnxn);
                    break;
                }
                case 106: {
                    lastOp = "ADDW";
                    AddWatchRequest addWatcherRequest = new AddWatchRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, addWatcherRequest);
                    this.zks.getZKDatabase().addWatch(addWatcherRequest.getPath(), cnxn, addWatcherRequest.getMode());
                    rsp = new ErrorResponse(0);
                    break;
                }
                case 6: {
                    lastOp = "GETA";
                    GetACLRequest getACLRequest = new GetACLRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getACLRequest);
                    path2 = getACLRequest.getPath();
                    DataNode n = this.zks.getZKDatabase().getNode(path2);
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(n), 17, request.authInfo, path2, null);
                    Stat stat = new Stat();
                    List<ACL> acl = this.zks.getZKDatabase().getACL(path2, stat);
                    this.requestPathMetricsCollector.registerRequest(request.type, getACLRequest.getPath());
                    try {
                        this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(n), 16, request.authInfo, path2, null);
                        rsp = new GetACLResponse(acl, stat);
                    }
                    catch (KeeperException.NoAuthException e3) {
                        ArrayList<ACL> acl1 = new ArrayList<ACL>(acl.size());
                        for (ACL a : acl) {
                            if ("digest".equals(a.getId().getScheme())) {
                                Id id = a.getId();
                                Id id1 = new Id(id.getScheme(), id.getId().replaceAll(":.*", ":x"));
                                acl1.add(new ACL(a.getPerms(), id1));
                                continue;
                            }
                            acl1.add(a);
                        }
                        rsp = new GetACLResponse(acl1, stat);
                    }
                    break;
                }
                case 8: {
                    lastOp = "GETC";
                    GetChildrenRequest getChildrenRequest = new GetChildrenRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getChildrenRequest);
                    path2 = getChildrenRequest.getPath();
                    rsp = this.handleGetChildrenRequest(getChildrenRequest, cnxn, request.authInfo);
                    this.requestPathMetricsCollector.registerRequest(request.type, path2);
                    break;
                }
                case 104: {
                    lastOp = "GETACN";
                    GetAllChildrenNumberRequest getAllChildrenNumberRequest = new GetAllChildrenNumberRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getAllChildrenNumberRequest);
                    path2 = getAllChildrenNumberRequest.getPath();
                    DataNode n = this.zks.getZKDatabase().getNode(path2);
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(n), 1, request.authInfo, path2, null);
                    int number = this.zks.getZKDatabase().getAllChildrenNumber(path2);
                    rsp = new GetAllChildrenNumberResponse(number);
                    break;
                }
                case 12: {
                    lastOp = "GETC";
                    GetChildren2Request getChildren2Request = new GetChildren2Request();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getChildren2Request);
                    Stat stat = new Stat();
                    path2 = getChildren2Request.getPath();
                    DataNode n = this.zks.getZKDatabase().getNode(path2);
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(n), 1, request.authInfo, path2, null);
                    List<String> children2 = this.zks.getZKDatabase().getChildren(path2, stat, getChildren2Request.getWatch() ? cnxn : null);
                    rsp = new GetChildren2Response(children2, stat);
                    this.requestPathMetricsCollector.registerRequest(request.type, path2);
                    break;
                }
                case 17: {
                    lastOp = "CHKW";
                    CheckWatchesRequest checkWatches = new CheckWatchesRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, checkWatches);
                    Watcher.WatcherType type2 = Watcher.WatcherType.fromInt(checkWatches.getType());
                    path2 = checkWatches.getPath();
                    boolean containsWatcher = this.zks.getZKDatabase().containsWatcher(path2, type2, cnxn);
                    if (!containsWatcher) {
                        String msg = String.format(Locale.ENGLISH, "%s (type: %s)", new Object[]{path2, type2});
                        throw new KeeperException.NoWatcherException(msg);
                    }
                    this.requestPathMetricsCollector.registerRequest(request.type, checkWatches.getPath());
                    break;
                }
                case 18: {
                    lastOp = "REMW";
                    RemoveWatchesRequest removeWatches = new RemoveWatchesRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, removeWatches);
                    Watcher.WatcherType type3 = Watcher.WatcherType.fromInt(removeWatches.getType());
                    path2 = removeWatches.getPath();
                    boolean removed = this.zks.getZKDatabase().removeWatch(path2, type3, cnxn);
                    if (!removed) {
                        String msg = String.format(Locale.ENGLISH, "%s (type: %s)", new Object[]{path2, type3});
                        throw new KeeperException.NoWatcherException(msg);
                    }
                    this.requestPathMetricsCollector.registerRequest(request.type, removeWatches.getPath());
                    break;
                }
                case 103: {
                    lastOp = "GETE";
                    GetEphemeralsRequest getEphemerals = new GetEphemeralsRequest();
                    ByteBufferInputStream.byteBuffer2Record(request.request, getEphemerals);
                    String prefixPath = getEphemerals.getPrefixPath();
                    Set<String> allEphems = this.zks.getZKDatabase().getDataTree().getEphemerals(request.sessionId);
                    ArrayList<String> ephemerals = new ArrayList<String>();
                    if (StringUtils.isBlank((String)prefixPath) || "/".equals(prefixPath.trim())) {
                        ephemerals.addAll(allEphems);
                    } else {
                        for (String p : allEphems) {
                            if (!p.startsWith(prefixPath)) continue;
                            ephemerals.add(p);
                        }
                    }
                    rsp = new GetEphemeralsResponse(ephemerals);
                    break;
                }
            }
        }
        catch (KeeperException.SessionMovedException e4) {
            cnxn.sendCloseSession();
            return;
        }
        catch (KeeperException e5) {
            err = e5.code();
        }
        catch (Exception e6) {
            LOG.error("Failed to process {}", (Object)request, (Object)e6);
            StringBuilder sb = new StringBuilder();
            ByteBuffer bb = request.request;
            bb.rewind();
            while (bb.hasRemaining()) {
                sb.append(Integer.toHexString(bb.get() & 0xFF));
            }
            LOG.error("Dumping request buffer: 0x{}", (Object)sb.toString());
            err = KeeperException.Code.MARSHALLINGERROR;
        }
        ReplyHeader hdr = new ReplyHeader(request.cxid, lastZxid, err.intValue());
        this.updateStats(request, lastOp, lastZxid);
        try {
            if (path2 == null || rsp == null) {
                cnxn.sendResponse(hdr, rsp, "response");
            } else {
                int opCode = request.type;
                Stat stat = null;
                switch (opCode) {
                    case 4: {
                        GetDataResponse getDataResponse = (GetDataResponse)rsp;
                        stat = getDataResponse.getStat();
                        cnxn.sendResponse(hdr, rsp, "response", path2, stat, opCode);
                        break;
                    }
                    case 12: {
                        GetChildren2Response getChildren2Response = (GetChildren2Response)rsp;
                        stat = getChildren2Response.getStat();
                        cnxn.sendResponse(hdr, rsp, "response", path2, stat, opCode);
                        break;
                    }
                    default: {
                        cnxn.sendResponse(hdr, rsp, "response");
                    }
                }
            }
            if (request.type == -11) {
                cnxn.sendCloseSession();
            }
        }
        catch (IOException e7) {
            LOG.error("FIXMSG", e7);
        }
    }

    private Record handleGetChildrenRequest(Record request, ServerCnxn cnxn, List<Id> authInfo) throws KeeperException, IOException {
        GetChildrenRequest getChildrenRequest = (GetChildrenRequest)request;
        String path2 = getChildrenRequest.getPath();
        DataNode n = this.zks.getZKDatabase().getNode(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        this.zks.checkACL(cnxn, this.zks.getZKDatabase().aclForNode(n), 1, authInfo, path2, null);
        List<String> children2 = this.zks.getZKDatabase().getChildren(path2, null, getChildrenRequest.getWatch() ? cnxn : null);
        return new GetChildrenResponse(children2);
    }

    private Record handleGetDataRequest(Record request, ServerCnxn cnxn, List<Id> authInfo) throws KeeperException, IOException {
        GetDataRequest getDataRequest = (GetDataRequest)request;
        String path2 = getDataRequest.getPath();
        DataNode n = this.zks.getZKDatabase().getNode(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        this.zks.checkACL(cnxn, this.zks.getZKDatabase().aclForNode(n), 1, authInfo, path2, null);
        Stat stat = new Stat();
        byte[] b = this.zks.getZKDatabase().getData(path2, stat, getDataRequest.getWatch() ? cnxn : null);
        return new GetDataResponse(b, stat);
    }

    private boolean closeSession(ServerCnxnFactory serverCnxnFactory, long sessionId) {
        if (serverCnxnFactory == null) {
            return false;
        }
        return serverCnxnFactory.closeSession(sessionId, ServerCnxn.DisconnectReason.CLIENT_CLOSED_SESSION);
    }

    private boolean connClosedByClient(Request request) {
        return request.cnxn == null;
    }

    @Override
    public void shutdown() {
        LOG.info("shutdown of request processor complete");
    }

    private void updateStats(Request request, String lastOp, long lastZxid) {
        if (request.cnxn == null) {
            return;
        }
        long currentTime = Time.currentElapsedTime();
        this.zks.serverStats().updateLatency(request, currentTime);
        request.cnxn.updateStatsForResponse(request.cxid, lastZxid, lastOp, request.createTime, currentTime);
    }
}

