/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.zookeeper.server.DataNode;
import io.mantisrx.shaded.org.apache.zookeeper.server.DigestCalculator;
import io.mantisrx.shaded.org.apache.zookeeper.server.NodeHashMap;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.util.AdHash;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NodeHashMapImpl
implements NodeHashMap {
    private final ConcurrentHashMap<String, DataNode> nodes;
    private final boolean digestEnabled;
    private final DigestCalculator digestCalculator;
    private final AdHash hash;

    public NodeHashMapImpl(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
        this.nodes = new ConcurrentHashMap();
        this.hash = new AdHash();
        this.digestEnabled = ZooKeeperServer.isDigestEnabled();
    }

    @Override
    public DataNode put(String path2, DataNode node2) {
        DataNode oldNode = this.nodes.put(path2, node2);
        this.addDigest(path2, node2);
        if (oldNode != null) {
            this.removeDigest(path2, oldNode);
        }
        return oldNode;
    }

    @Override
    public DataNode putWithoutDigest(String path2, DataNode node2) {
        return this.nodes.put(path2, node2);
    }

    @Override
    public DataNode get(String path2) {
        return this.nodes.get(path2);
    }

    @Override
    public DataNode remove(String path2) {
        DataNode oldNode = this.nodes.remove(path2);
        if (oldNode != null) {
            this.removeDigest(path2, oldNode);
        }
        return oldNode;
    }

    @Override
    public Set<Map.Entry<String, DataNode>> entrySet() {
        return this.nodes.entrySet();
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.hash.clear();
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public void preChange(String path2, DataNode node2) {
        this.removeDigest(path2, node2);
    }

    @Override
    public void postChange(String path2, DataNode node2) {
        node2.digestCached = false;
        this.addDigest(path2, node2);
    }

    private void addDigest(String path2, DataNode node2) {
        if (path2.startsWith("/zookeeper/")) {
            return;
        }
        if (this.digestEnabled) {
            this.hash.addDigest(this.digestCalculator.calculateDigest(path2, node2));
        }
    }

    private void removeDigest(String path2, DataNode node2) {
        if (path2.startsWith("/zookeeper/")) {
            return;
        }
        if (this.digestEnabled) {
            this.hash.removeDigest(this.digestCalculator.calculateDigest(path2, node2));
        }
    }

    @Override
    public long getDigest() {
        return this.hash.getHash();
    }
}

