/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCache {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCache.class);
    public static final int DEFAULT_RESPONSE_CACHE_SIZE = 400;
    private final int cacheSize;
    private final Map<String, Entry> cache;

    public ResponseCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this.cache = Collections.synchronizedMap(new LRUCache(cacheSize));
        LOG.info("Response cache size is initialized with value {}.", (Object)cacheSize);
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void put(String path2, byte[] data2, Stat stat) {
        Entry entry = new Entry();
        entry.data = data2;
        entry.stat = stat;
        this.cache.put(path2, entry);
    }

    public byte[] get(String key2, Stat stat) {
        Entry entry = this.cache.get(key2);
        if (entry == null) {
            return null;
        }
        if (!stat.equals(entry.stat)) {
            this.cache.remove(key2);
            return null;
        }
        return entry.data;
    }

    public boolean isEnabled() {
        return this.cacheSize > 0;
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private int cacheSize;

        LRUCache(int cacheSize) {
            super(cacheSize / 4);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() >= this.cacheSize;
        }
    }

    private static class Entry {
        public Stat stat;
        public byte[] data;

        private Entry() {
        }
    }
}

