/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.auth;

import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.mantisrx.shaded.org.apache.zookeeper.server.auth.AuthenticationProvider;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnsembleAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EnsembleAuthenticationProvider.class);
    public static final String ENSEMBLE_PROPERTY = "zookeeper.ensembleAuthName";
    private static final int MIN_LOGGING_INTERVAL_MS = 1000;
    private Set<String> ensembleNames;
    private long lastFailureLogged;

    public EnsembleAuthenticationProvider() {
        String namesCSV = System.getProperty(ENSEMBLE_PROPERTY);
        if (namesCSV != null) {
            LOG.info("Set expected ensemble names to {}", (Object)namesCSV);
            this.setEnsembleNames(namesCSV);
        }
    }

    public void setEnsembleNames(String namesCSV) {
        this.ensembleNames = new HashSet<String>();
        for (String name2 : namesCSV.split(",")) {
            this.ensembleNames.add(name2.trim());
        }
    }

    @Override
    public String getScheme() {
        return "ensemble";
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        if (authData == null || authData.length == 0) {
            ServerMetrics.getMetrics().ENSEMBLE_AUTH_SKIP.add(1L);
            return KeeperException.Code.OK;
        }
        String receivedEnsembleName = new String(authData);
        if (this.ensembleNames == null) {
            ServerMetrics.getMetrics().ENSEMBLE_AUTH_SKIP.add(1L);
            return KeeperException.Code.OK;
        }
        if (this.ensembleNames.contains(receivedEnsembleName)) {
            ServerMetrics.getMetrics().ENSEMBLE_AUTH_SUCCESS.add(1L);
            return KeeperException.Code.OK;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastFailureLogged + 1000L < currentTime) {
            String id = cnxn.getRemoteSocketAddress().getAddress().getHostAddress();
            LOG.warn("Unexpected ensemble name: ensemble name: {} client ip: {}", (Object)receivedEnsembleName, (Object)id);
            this.lastFailureLogged = currentTime;
        }
        ServerMetrics.getMetrics().ENSEMBLE_AUTH_FAIL.add(1L);
        cnxn.close(ServerCnxn.DisconnectReason.FAILED_HANDSHAKE);
        return KeeperException.Code.BADARGUMENTS;
    }

    @Override
    public boolean matches(String id, String aclExpr) {
        return false;
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public boolean isValid(String id) {
        return false;
    }
}

