/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.auth;

import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.data.Id;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyAuthenticationProvider
extends ServerAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(KeyAuthenticationProvider.class);

    @Override
    public String getScheme() {
        return "key";
    }

    private byte[] getKey(ZooKeeperServer zks) {
        ZKDatabase db = zks.getZKDatabase();
        if (db != null) {
            try {
                Stat stat = new Stat();
                return db.getData("/key", stat, null);
            }
            catch (KeeperException.NoNodeException e2) {
                LOG.error("getData failed", e2);
            }
        }
        return null;
    }

    private boolean validate(byte[] key2, byte[] auth) {
        try {
            String keyStr = new String(key2, StandardCharsets.UTF_8);
            String authStr = new String(auth, StandardCharsets.UTF_8);
            int keyVal = Integer.parseInt(keyStr);
            int authVal = Integer.parseInt(authStr);
            if (keyVal != 0 && authVal % keyVal != 0) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            LOG.error("bad formatting", nfe);
            return false;
        }
        return true;
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerAuthenticationProvider.ServerObjs serverObjs, byte[] authData) {
        byte[] key2 = this.getKey(serverObjs.getZks());
        String authStr = "";
        String keyStr = "";
        try {
            authStr = new String(authData, StandardCharsets.UTF_8);
        }
        catch (Exception e2) {
            LOG.error("UTF-8", e2);
        }
        if (key2 != null && !this.validate(key2, authData)) {
            try {
                keyStr = new String(key2, StandardCharsets.UTF_8);
            }
            catch (Exception e3) {
                LOG.error("UTF-8", e3);
                keyStr = authStr;
            }
            LOG.debug("KeyAuthenticationProvider handleAuthentication ({}, {}) -> FAIL.\n", (Object)keyStr, (Object)authStr);
            return KeeperException.Code.AUTHFAILED;
        }
        LOG.debug("KeyAuthenticationProvider handleAuthentication -> OK.\n");
        serverObjs.getCnxn().addAuthInfo(new Id(this.getScheme(), keyStr));
        return KeeperException.Code.OK;
    }

    @Override
    public boolean matches(ServerAuthenticationProvider.ServerObjs serverObjs, ServerAuthenticationProvider.MatchValues matchValues) {
        return matchValues.getId().equals(matchValues.getAclExpr());
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String id) {
        return true;
    }
}

