/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.util;

import io.mantisrx.shaded.org.apache.zookeeper.server.ServerConfig;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmPauseMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(JvmPauseMonitor.class);
    public static final String JVM_PAUSE_MONITOR_FEATURE_SWITCH_KEY = "jvm.pause.monitor";
    protected long sleepTimeMs;
    public static final String SLEEP_TIME_MS_KEY = "jvm.pause.sleep.time.ms";
    public static final long SLEEP_TIME_MS_DEFAULT = 500L;
    protected long warnThresholdMs;
    public static final String WARN_THRESHOLD_KEY = "jvm.pause.warn-threshold.ms";
    public static final long WARN_THRESHOLD_DEFAULT = 10000L;
    protected long infoThresholdMs;
    public static final String INFO_THRESHOLD_KEY = "jvm.pause.info-threshold.ms";
    public static final long INFO_THRESHOLD_DEFAULT = 1000L;
    private long numGcWarnThresholdExceeded = 0L;
    private long numGcInfoThresholdExceeded = 0L;
    private long totalGcExtraSleepTime = 0L;
    private Thread monitorThread;
    private volatile boolean shouldRun = true;

    public JvmPauseMonitor(QuorumPeerConfig config) {
        this.warnThresholdMs = config.getJvmPauseWarnThresholdMs();
        this.infoThresholdMs = config.getJvmPauseInfoThresholdMs();
        this.sleepTimeMs = config.getJvmPauseSleepTimeMs();
    }

    public JvmPauseMonitor(ServerConfig config) {
        this.warnThresholdMs = config.getJvmPauseWarnThresholdMs();
        this.infoThresholdMs = config.getJvmPauseInfoThresholdMs();
        this.sleepTimeMs = config.getJvmPauseSleepTimeMs();
    }

    public void serviceStart() {
        this.monitorThread = new Thread(new JVMMonitor());
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    public void serviceStop() {
        this.shouldRun = false;
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
            try {
                this.monitorThread.join();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isStarted() {
        return this.monitorThread != null;
    }

    public long getNumGcWarnThresholdExceeded() {
        return this.numGcWarnThresholdExceeded;
    }

    public long getNumGcInfoThresholdExceeded() {
        return this.numGcInfoThresholdExceeded;
    }

    public long getTotalGcExtraSleepTime() {
        return this.totalGcExtraSleepTime;
    }

    private String formatMessage(long extraSleepTime, Map<String, GcTimes> gcTimesAfterSleep, Map<String, GcTimes> gcTimesBeforeSleep) {
        HashSet<String> gcBeanNames = new HashSet<String>(gcTimesAfterSleep.keySet());
        gcBeanNames.retainAll(gcTimesBeforeSleep.keySet());
        ArrayList<String> gcDiffs = new ArrayList<String>();
        for (String name2 : gcBeanNames) {
            GcTimes diff2 = gcTimesAfterSleep.get(name2).subtract(gcTimesBeforeSleep.get(name2));
            if (diff2.gcCount == 0L) continue;
            gcDiffs.add("GC pool '" + name2 + "' had collection(s): " + diff2.toString());
        }
        String ret = String.format("Detected pause in JVM or host machine (eg GC): pause of approximately %d ms, total pause: info level: %d, warn level: %d %n", extraSleepTime, this.numGcInfoThresholdExceeded, this.numGcWarnThresholdExceeded);
        ret = gcDiffs.isEmpty() ? ret + "No GCs detected" : ret + String.join((CharSequence)"\n", gcDiffs);
        return ret;
    }

    private Map<String, GcTimes> getGcTimes() {
        HashMap<String, GcTimes> map2 = new HashMap<String, GcTimes>();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            map2.put(gcBean.getName(), new GcTimes(gcBean));
        }
        return map2;
    }

    private class JVMMonitor
    implements Runnable {
        private JVMMonitor() {
        }

        @Override
        public void run() {
            Map gcTimesBeforeSleep = JvmPauseMonitor.this.getGcTimes();
            LOG.info("Starting JVM Pause Monitor with infoThresholdMs:{} warnThresholdMs:{} and sleepTimeMs:{}", JvmPauseMonitor.this.infoThresholdMs, JvmPauseMonitor.this.warnThresholdMs, JvmPauseMonitor.this.sleepTimeMs);
            while (JvmPauseMonitor.this.shouldRun) {
                long startTime = Instant.now().toEpochMilli();
                try {
                    Thread.sleep(JvmPauseMonitor.this.sleepTimeMs);
                }
                catch (InterruptedException ie) {
                    return;
                }
                long endTime = Instant.now().toEpochMilli();
                long extraSleepTime = endTime - startTime - JvmPauseMonitor.this.sleepTimeMs;
                Map gcTimesAfterSleep = JvmPauseMonitor.this.getGcTimes();
                if (extraSleepTime > JvmPauseMonitor.this.warnThresholdMs) {
                    ++JvmPauseMonitor.this.numGcWarnThresholdExceeded;
                    LOG.warn(JvmPauseMonitor.this.formatMessage(extraSleepTime, gcTimesAfterSleep, gcTimesBeforeSleep));
                } else if (extraSleepTime > JvmPauseMonitor.this.infoThresholdMs) {
                    ++JvmPauseMonitor.this.numGcInfoThresholdExceeded;
                    LOG.info(JvmPauseMonitor.this.formatMessage(extraSleepTime, gcTimesAfterSleep, gcTimesBeforeSleep));
                }
                JvmPauseMonitor.this.totalGcExtraSleepTime = JvmPauseMonitor.this.totalGcExtraSleepTime + extraSleepTime;
                gcTimesBeforeSleep = gcTimesAfterSleep;
            }
        }
    }

    private static class GcTimes {
        private long gcCount;
        private long gcTimeMillis;

        private GcTimes(GarbageCollectorMXBean gcBean) {
            this.gcCount = gcBean.getCollectionCount();
            this.gcTimeMillis = gcBean.getCollectionTime();
        }

        private GcTimes(long count2, long time2) {
            this.gcCount = count2;
            this.gcTimeMillis = time2;
        }

        private GcTimes subtract(GcTimes other) {
            return new GcTimes(this.gcCount - other.gcCount, this.gcTimeMillis - other.gcTimeMillis);
        }

        public String toString() {
            return "count=" + this.gcCount + " time=" + this.gcTimeMillis + "ms";
        }
    }
}

