/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.util;

import java.io.File;
import org.slf4j.Logger;

public final class VerifyingFileFactory {
    private final boolean warnForRelativePath;
    private final boolean failForNonExistingPath;
    private final Logger log;

    public VerifyingFileFactory(Builder builder) {
        this.warnForRelativePath = builder.warnForRelativePathOption;
        this.failForNonExistingPath = builder.failForNonExistingPathOption;
        this.log = builder.log;
        assert (this.log != null);
    }

    public File create(String path2) {
        File file2 = new File(path2);
        return this.validate(file2);
    }

    public File validate(File file2) {
        if (this.warnForRelativePath) {
            this.doWarnForRelativePath(file2);
        }
        if (this.failForNonExistingPath) {
            this.doFailForNonExistingPath(file2);
        }
        return file2;
    }

    private void doFailForNonExistingPath(File file2) {
        if (!file2.exists()) {
            throw new IllegalArgumentException(file2.toString() + " file is missing");
        }
    }

    private void doWarnForRelativePath(File file2) {
        if (file2.isAbsolute()) {
            return;
        }
        if (file2.getPath().substring(0, 2).equals("." + File.separator)) {
            return;
        }
        this.log.warn(file2.getPath() + " is relative. Prepend ." + File.separator + " to indicate that you're sure!");
    }

    public static class Builder {
        private boolean warnForRelativePathOption = false;
        private boolean failForNonExistingPathOption = false;
        private final Logger log;

        public Builder(Logger log2) {
            this.log = log2;
        }

        public Builder warnForRelativePath() {
            this.warnForRelativePathOption = true;
            return this;
        }

        public Builder failForNonExistingPath() {
            this.failForNonExistingPathOption = true;
            return this;
        }

        public VerifyingFileFactory build() {
            return new VerifyingFileFactory(this);
        }
    }
}

