/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.watch;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class PathParentIterator
implements Iterator<String> {
    private String path;
    private final int maxLevel;
    private int level = -1;

    public static PathParentIterator forAll(String path2) {
        return new PathParentIterator(path2, Integer.MAX_VALUE);
    }

    public static PathParentIterator forPathOnly(String path2) {
        return new PathParentIterator(path2, 0);
    }

    private PathParentIterator(String path2, int maxLevel) {
        this.path = path2;
        this.maxLevel = maxLevel;
    }

    public Iterable<String> asIterable() {
        return () -> this;
    }

    @Override
    public boolean hasNext() {
        return !this.path.isEmpty() && this.level < this.maxLevel;
    }

    public boolean atParentPath() {
        return this.level > 0;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String localPath = this.path;
        ++this.level;
        if (this.path.equals("/")) {
            this.path = "";
        } else {
            this.path = this.path.substring(0, this.path.lastIndexOf(47));
            if (this.path.length() == 0) {
                this.path = "/";
            }
        }
        return localPath;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

