/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.watch;

import io.mantisrx.shaded.org.apache.zookeeper.WatchedEvent;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.mantisrx.shaded.org.apache.zookeeper.server.util.BitHashSet;
import io.mantisrx.shaded.org.apache.zookeeper.server.util.BitMap;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.IDeadWatcherListener;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.IWatchManager;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatcherCleaner;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatcherOrBitSet;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatchesPathReport;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatchesReport;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatchesSummary;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchManagerOptimized
implements IWatchManager,
IDeadWatcherListener {
    private static final Logger LOG = LoggerFactory.getLogger(WatchManagerOptimized.class);
    private final ConcurrentHashMap<String, BitHashSet> pathWatches = new ConcurrentHashMap();
    private final BitMap<Watcher> watcherBitIdMap = new BitMap();
    private final WatcherCleaner watcherCleaner;
    private final ReentrantReadWriteLock addRemovePathRWLock = new ReentrantReadWriteLock();

    public WatchManagerOptimized() {
        this.watcherCleaner = new WatcherCleaner(this);
        this.watcherCleaner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addWatch(String path2, Watcher watcher) {
        boolean result = false;
        this.addRemovePathRWLock.readLock().lock();
        try {
            if (this.isDeadWatcher(watcher)) {
                LOG.debug("Ignoring addWatch with closed cnxn");
            } else {
                BitHashSet existingWatchers;
                Integer bit = this.watcherBitIdMap.add(watcher);
                BitHashSet watchers = this.pathWatches.get(path2);
                if (watchers == null && (existingWatchers = this.pathWatches.putIfAbsent(path2, watchers = new BitHashSet())) != null) {
                    watchers = existingWatchers;
                }
                result = watchers.add(bit);
            }
        }
        finally {
            this.addRemovePathRWLock.readLock().unlock();
        }
        return result;
    }

    @Override
    public boolean containsWatcher(String path2, Watcher watcher) {
        BitHashSet watchers = this.pathWatches.get(path2);
        return watchers != null && watchers.contains(this.watcherBitIdMap.getBit(watcher));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWatcher(String path2, Watcher watcher) {
        this.addRemovePathRWLock.writeLock().lock();
        try {
            BitHashSet list = this.pathWatches.get(path2);
            if (list == null || !list.remove(this.watcherBitIdMap.getBit(watcher))) {
                boolean bl = false;
                return bl;
            }
            if (list.isEmpty()) {
                this.pathWatches.remove(path2);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.addRemovePathRWLock.writeLock().unlock();
        }
    }

    @Override
    public void removeWatcher(Watcher watcher) {
        Integer watcherBit;
        this.addRemovePathRWLock.writeLock().lock();
        try {
            watcherBit = this.watcherBitIdMap.getBit(watcher);
            if (watcherBit == null) {
                return;
            }
        }
        finally {
            this.addRemovePathRWLock.writeLock().unlock();
        }
        this.watcherCleaner.addDeadWatcher(watcherBit);
    }

    @Override
    public void processDeadWatchers(Set<Integer> deadWatchers) {
        BitSet bits = new BitSet();
        Iterator<Object> iterator = deadWatchers.iterator();
        while (iterator.hasNext()) {
            int dw = iterator.next();
            bits.set(dw);
        }
        for (BitHashSet watchers : this.pathWatches.values()) {
            watchers.remove(deadWatchers, bits);
        }
        for (Integer wbit : deadWatchers) {
            this.watcherBitIdMap.remove(wbit);
        }
    }

    @Override
    public WatcherOrBitSet triggerWatch(String path2, Watcher.Event.EventType type2) {
        return this.triggerWatch(path2, type2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatcherOrBitSet triggerWatch(String path2, Watcher.Event.EventType type2, WatcherOrBitSet suppress) {
        WatchedEvent e2 = new WatchedEvent(type2, Watcher.Event.KeeperState.SyncConnected, path2);
        BitHashSet watchers = this.remove(path2);
        if (watchers == null) {
            return null;
        }
        int triggeredWatches = 0;
        BitHashSet bitHashSet = watchers;
        synchronized (bitHashSet) {
            for (Integer wBit : watchers) {
                Watcher w;
                if (suppress != null && suppress.contains(wBit) || (w = this.watcherBitIdMap.get(wBit)) == null || this.isDeadWatcher(w)) continue;
                w.process(e2);
                ++triggeredWatches;
            }
        }
        this.updateMetrics(type2, triggeredWatches);
        return new WatcherOrBitSet(watchers);
    }

    @Override
    public int size() {
        int size = 0;
        for (BitHashSet watches : this.pathWatches.values()) {
            size += watches.size();
        }
        return size;
    }

    @Override
    public void shutdown() {
        if (this.watcherCleaner != null) {
            this.watcherCleaner.shutdown();
        }
    }

    private BitHashSet remove(String path2) {
        this.addRemovePathRWLock.writeLock().lock();
        try {
            BitHashSet bitHashSet = this.pathWatches.remove(path2);
            return bitHashSet;
        }
        finally {
            this.addRemovePathRWLock.writeLock().unlock();
        }
    }

    void updateMetrics(Watcher.Event.EventType type2, int size) {
        switch (type2) {
            case NodeCreated: {
                ServerMetrics.getMetrics().NODE_CREATED_WATCHER.add(size);
                break;
            }
            case NodeDeleted: {
                ServerMetrics.getMetrics().NODE_DELETED_WATCHER.add(size);
                break;
            }
            case NodeDataChanged: {
                ServerMetrics.getMetrics().NODE_CHANGED_WATCHER.add(size);
                break;
            }
            case NodeChildrenChanged: {
                ServerMetrics.getMetrics().NODE_CHILDREN_WATCHER.add(size);
                break;
            }
        }
    }

    boolean isDeadWatcher(Watcher watcher) {
        return watcher instanceof ServerCnxn && ((ServerCnxn)watcher).isStale();
    }

    int pathSize() {
        return this.pathWatches.size();
    }

    @Override
    public WatchesSummary getWatchesSummary() {
        return new WatchesSummary(this.watcherBitIdMap.size(), this.pathSize(), this.size());
    }

    @Override
    public WatchesReport getWatches() {
        HashMap<Long, Set<String>> id2paths = new HashMap<Long, Set<String>>();
        for (Map.Entry<Watcher, Set<String>> e2 : this.getWatcher2PathesMap().entrySet()) {
            Long id = ((ServerCnxn)e2.getKey()).getSessionId();
            HashSet paths = new HashSet(e2.getValue());
            id2paths.put(id, paths);
        }
        return new WatchesReport(id2paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatchesPathReport getWatchesByPath() {
        HashMap<String, Set<Long>> path2ids = new HashMap<String, Set<Long>>();
        for (Map.Entry<String, BitHashSet> e2 : this.pathWatches.entrySet()) {
            BitHashSet watchers;
            BitHashSet bitHashSet = watchers = e2.getValue();
            synchronized (bitHashSet) {
                HashSet<Long> ids = new HashSet<Long>(watchers.size());
                path2ids.put(e2.getKey(), ids);
                for (Integer wbit : watchers) {
                    Watcher watcher = this.watcherBitIdMap.get(wbit);
                    if (!(watcher instanceof ServerCnxn)) continue;
                    ids.add(((ServerCnxn)watcher).getSessionId());
                }
            }
        }
        return new WatchesPathReport(path2ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Watcher, Set<String>> getWatcher2PathesMap() {
        HashMap<Watcher, Set<String>> watcher2paths = new HashMap<Watcher, Set<String>>();
        for (Map.Entry<String, BitHashSet> e2 : this.pathWatches.entrySet()) {
            BitHashSet watchers;
            String path2 = e2.getKey();
            BitHashSet bitHashSet = watchers = e2.getValue();
            synchronized (bitHashSet) {
                for (Integer wbit : watchers) {
                    Watcher w = this.watcherBitIdMap.get(wbit);
                    if (w == null) continue;
                    if (!watcher2paths.containsKey(w)) {
                        watcher2paths.put(w, new HashSet());
                    }
                    ((Set)watcher2paths.get(w)).add(path2);
                }
            }
        }
        return watcher2paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpWatches(PrintWriter pwriter, boolean byPath) {
        if (byPath) {
            for (Map.Entry<String, BitHashSet> e2 : this.pathWatches.entrySet()) {
                BitHashSet watchers;
                pwriter.println(e2.getKey());
                BitHashSet bitHashSet = watchers = e2.getValue();
                synchronized (bitHashSet) {
                    for (Integer wbit : watchers) {
                        Watcher w = this.watcherBitIdMap.get(wbit);
                        if (!(w instanceof ServerCnxn)) continue;
                        pwriter.print("\t0x");
                        pwriter.print(Long.toHexString(((ServerCnxn)w).getSessionId()));
                        pwriter.print("\n");
                    }
                }
            }
        } else {
            for (Map.Entry<Watcher, Set<String>> e3 : this.getWatcher2PathesMap().entrySet()) {
                pwriter.print("0x");
                pwriter.println(Long.toHexString(((ServerCnxn)e3.getKey()).getSessionId()));
                for (String path2 : e3.getValue()) {
                    pwriter.print("\t");
                    pwriter.println(path2);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.watcherBitIdMap.size()).append(" connections watching ").append(this.pathSize()).append(" paths\n");
        sb.append("Total watches:").append(this.size());
        return sb.toString();
    }
}

