/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.watch;

import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import io.mantisrx.shaded.org.apache.zookeeper.server.watch.WatcherMode;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class WatcherModeManager {
    private final Map<Key, WatcherMode> watcherModes = new ConcurrentHashMap<Key, WatcherMode>();
    private final AtomicInteger recursiveQty = new AtomicInteger(0);

    WatcherModeManager() {
    }

    Map<Key, WatcherMode> getWatcherModes() {
        return this.watcherModes;
    }

    void setWatcherMode(Watcher watcher, String path2, WatcherMode mode) {
        if (mode == WatcherMode.DEFAULT_WATCHER_MODE) {
            this.removeWatcher(watcher, path2);
        } else {
            this.adjustRecursiveQty(this.watcherModes.put(new Key(watcher, path2), mode), mode);
        }
    }

    WatcherMode getWatcherMode(Watcher watcher, String path2) {
        return this.watcherModes.getOrDefault(new Key(watcher, path2), WatcherMode.DEFAULT_WATCHER_MODE);
    }

    void removeWatcher(Watcher watcher, String path2) {
        this.adjustRecursiveQty(this.watcherModes.remove(new Key(watcher, path2)), WatcherMode.DEFAULT_WATCHER_MODE);
    }

    int getRecursiveQty() {
        return this.recursiveQty.get();
    }

    private void adjustRecursiveQty(WatcherMode oldMode, WatcherMode newMode) {
        if (oldMode == null) {
            oldMode = WatcherMode.DEFAULT_WATCHER_MODE;
        }
        if (oldMode.isRecursive() != newMode.isRecursive()) {
            if (newMode.isRecursive()) {
                this.recursiveQty.incrementAndGet();
            } else {
                this.recursiveQty.decrementAndGet();
            }
        }
    }

    private static class Key {
        private final Watcher watcher;
        private final String path;

        Key(Watcher watcher, String path2) {
            this.watcher = watcher;
            this.path = path2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key2 = (Key)o;
            return this.watcher.equals(key2.watcher) && this.path.equals(key2.path);
        }

        public int hashCode() {
            return Objects.hash(this.watcher, this.path);
        }
    }
}

