/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularBlockingQueue<E>
implements BlockingQueue<E> {
    private static final Logger LOG = LoggerFactory.getLogger(CircularBlockingQueue.class);
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final ArrayDeque<E> queue;
    private final int maxSize;
    private long droppedCount;

    public CircularBlockingQueue(int queueSize) {
        this.queue = new ArrayDeque(queueSize);
        this.maxSize = queueSize;
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.droppedCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e2) {
        Objects.requireNonNull(e2);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.queue.size() == this.maxSize) {
                E discard = this.queue.remove();
                ++this.droppedCount;
                LOG.debug("Queue is full. Discarding oldest element [count={}]: {}", (Object)this.droppedCount, (Object)discard);
            }
            this.queue.add(e2);
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.queue.isEmpty()) {
                if (nanos <= 0L) {
                    E e2 = null;
                    return e2;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E e3 = this.queue.poll();
            return e3;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.queue.isEmpty()) {
                this.notEmpty.await();
            }
            E e2 = this.queue.poll();
            return e2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.queue.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public long getDroppedCount() {
        return this.droppedCount;
    }

    boolean isConsumerThreadBlocked() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = lock.getWaitQueueLength(this.notEmpty) > 0;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e2, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(E e2) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remainingCapacity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }
}

