/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.queue;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ExceptionEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import io.mantisrx.shaded.org.jboss.netty.handler.queue.BlockingReadTimeoutException;
import io.mantisrx.shaded.org.jboss.netty.util.internal.DeadLockProofWorker;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingReadHandler<E>
extends SimpleChannelUpstreamHandler {
    private final BlockingQueue<ChannelEvent> queue;
    private volatile boolean closed;

    public BlockingReadHandler() {
        this(new LinkedBlockingQueue<ChannelEvent>());
    }

    public BlockingReadHandler(BlockingQueue<ChannelEvent> queue) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        this.queue = queue;
    }

    protected BlockingQueue<ChannelEvent> getQueue() {
        return this.queue;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public E read() throws IOException, InterruptedException {
        ChannelEvent e2 = this.readEvent();
        if (e2 == null) {
            return null;
        }
        if (e2 instanceof MessageEvent) {
            return this.getMessage((MessageEvent)e2);
        }
        if (e2 instanceof ExceptionEvent) {
            throw (IOException)new IOException().initCause(((ExceptionEvent)e2).getCause());
        }
        throw new IllegalStateException();
    }

    public E read(long timeout, TimeUnit unit) throws IOException, InterruptedException {
        ChannelEvent e2 = this.readEvent(timeout, unit);
        if (e2 == null) {
            return null;
        }
        if (e2 instanceof MessageEvent) {
            return this.getMessage((MessageEvent)e2);
        }
        if (e2 instanceof ExceptionEvent) {
            throw (IOException)new IOException().initCause(((ExceptionEvent)e2).getCause());
        }
        throw new IllegalStateException();
    }

    public ChannelEvent readEvent() throws InterruptedException {
        BlockingReadHandler.detectDeadLock();
        if (this.isClosed() && this.getQueue().isEmpty()) {
            return null;
        }
        ChannelEvent e2 = this.getQueue().take();
        if (e2 instanceof ChannelStateEvent) {
            assert (this.closed);
            return null;
        }
        return e2;
    }

    public ChannelEvent readEvent(long timeout, TimeUnit unit) throws InterruptedException, BlockingReadTimeoutException {
        BlockingReadHandler.detectDeadLock();
        if (this.isClosed() && this.getQueue().isEmpty()) {
            return null;
        }
        ChannelEvent e2 = this.getQueue().poll(timeout, unit);
        if (e2 == null) {
            throw new BlockingReadTimeoutException();
        }
        if (e2 instanceof ChannelStateEvent) {
            assert (this.closed);
            return null;
        }
        return e2;
    }

    private static void detectDeadLock() {
        if (DeadLockProofWorker.PARENT.get() != null) {
            throw new IllegalStateException("read*(...) in I/O thread causes a dead lock or sudden performance drop. Implement a state machine or call read*() from a different thread.");
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        this.getQueue().put(e2);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e2) throws Exception {
        this.getQueue().put(e2);
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        this.closed = true;
        this.getQueue().put(e2);
    }

    private E getMessage(MessageEvent e2) {
        return (E)e2.getMessage();
    }
}

