/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.concurrent;

import io.vavr.CheckedFunction0;
import io.vavr.collection.Queue;
import io.vavr.concurrent.Future;
import io.vavr.concurrent.GuardedBy;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

final class FutureImpl<T>
implements Future<T> {
    private final ExecutorService executorService;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private volatile Option<Try<T>> value = Option.none();
    @GuardedBy(value="lock")
    private Queue<Consumer<? super Try<T>>> actions = Queue.empty();
    @GuardedBy(value="lock")
    private java.util.concurrent.Future<?> job = null;

    FutureImpl(ExecutorService executorService) {
        Objects.requireNonNull(executorService, "executorService is null");
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> await() {
        if (!this.isCompleted()) {
            Object monitor = new Object();
            this.onComplete(ignored -> {
                Object object = monitor;
                synchronized (object) {
                    monitor.notify();
                }
            });
            Object object = monitor;
            synchronized (object) {
                if (!this.isCompleted()) {
                    Try.run(monitor::wait);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCompleted()) {
                return false;
            }
            return Try.of(() -> this.job == null || this.job.cancel(mayInterruptIfRunning)).onSuccess(cancelled -> {
                if (cancelled.booleanValue()) {
                    this.complete(Try.failure(new CancellationException()));
                }
            }).getOrElse(false);
        }
    }

    @Override
    public ExecutorService executorService() {
        return this.executorService;
    }

    @Override
    public Option<Try<T>> getValue() {
        return this.value;
    }

    @Override
    public boolean isCompleted() {
        return this.value.isDefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> onComplete(Consumer<? super Try<T>> action2) {
        Objects.requireNonNull(action2, "action is null");
        if (this.isCompleted()) {
            this.perform(action2);
        } else {
            Object object = this.lock;
            synchronized (object) {
                if (this.isCompleted()) {
                    this.perform(action2);
                } else {
                    this.actions = this.actions.enqueue(action2);
                }
            }
        }
        return this;
    }

    @Override
    public String toString() {
        return this.stringPrefix() + "(" + this.value.map(String::valueOf).getOrElse("?") + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(CheckedFunction0<? extends T> computation) {
        Objects.requireNonNull(computation, "computation is null");
        Object object = this.lock;
        synchronized (object) {
            block8: {
                if (this.job != null) {
                    throw new IllegalStateException("The Future is already running.");
                }
                if (this.isCompleted()) {
                    throw new IllegalStateException("The Future is completed.");
                }
                try {
                    java.util.concurrent.Future<?> tmpJob = this.executorService.submit(() -> this.complete(Try.of(computation)));
                    if (!this.isCompleted()) {
                        this.job = tmpJob;
                    }
                }
                catch (Throwable t) {
                    if (this.isCompleted()) break block8;
                    this.complete(Try.failure(t));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryComplete(Try<? extends T> value) {
        Objects.requireNonNull(value, "value is null");
        Object object = this.lock;
        synchronized (object) {
            if (this.isCompleted()) {
                return false;
            }
            this.complete(value);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(Try<? extends T> value) {
        Queue<Consumer<Try<Consumer>>> actions;
        Objects.requireNonNull(value, "value is null");
        Object object = this.lock;
        synchronized (object) {
            if (this.isCompleted()) {
                throw new IllegalStateException("The Future is completed.");
            }
            actions = this.actions;
            this.value = Option.some(Try.narrow(value));
            this.actions = null;
            this.job = null;
        }
        actions.forEach(this::perform);
    }

    private void perform(Consumer<? super Try<T>> action2) {
        Try.run(() -> this.executorService.execute(() -> action2.accept(this.value.get())));
    }
}

