/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

final class SoundexUtils {
    SoundexUtils() {
    }

    static String clean(String str2) {
        if (SoundexUtils.isEmpty(str2)) {
            return str2;
        }
        int len = str2.length();
        char[] chars2 = new char[len];
        int count2 = 0;
        for (int i = 0; i < len; ++i) {
            if (!Character.isLetter(str2.charAt(i))) continue;
            chars2[count2++] = str2.charAt(i);
        }
        if (count2 == len) {
            return str2.toUpperCase(Locale.ENGLISH);
        }
        return new String(chars2, 0, count2).toUpperCase(Locale.ENGLISH);
    }

    static int difference(StringEncoder encoder, String s1, String s2) throws EncoderException {
        return SoundexUtils.differenceEncoded(encoder.encode(s1), encoder.encode(s2));
    }

    static int differenceEncoded(String es1, String es2) {
        if (es1 == null || es2 == null) {
            return 0;
        }
        int lengthToMatch = Math.min(es1.length(), es2.length());
        int diff2 = 0;
        for (int i = 0; i < lengthToMatch; ++i) {
            if (es1.charAt(i) != es2.charAt(i)) continue;
            ++diff2;
        }
        return diff2;
    }

    static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }
}

