/*
 * Decompiled with CFR 0.152.
 */
package rx.exceptions;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import rx.exceptions.Exceptions;
import rx.plugins.RxJavaPlugins;

public final class OnErrorThrowable
extends RuntimeException {
    private static final long serialVersionUID = -569558213262703934L;
    private final boolean hasValue;
    private final Object value;

    private OnErrorThrowable(Throwable exception) {
        super(exception);
        this.hasValue = false;
        this.value = null;
    }

    private OnErrorThrowable(Throwable exception, Object value) {
        super(exception);
        Object v;
        this.hasValue = true;
        if (value instanceof Serializable) {
            v = value;
        } else {
            try {
                v = String.valueOf(value);
            }
            catch (Throwable ex) {
                v = ex.getMessage();
            }
        }
        this.value = v;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isValueNull() {
        return this.hasValue;
    }

    public static OnErrorThrowable from(Throwable t) {
        Throwable cause;
        if (t == null) {
            t = new NullPointerException();
        }
        if ((cause = Exceptions.getFinalCause(t)) instanceof OnNextValue) {
            return new OnErrorThrowable(t, ((OnNextValue)cause).getValue());
        }
        return new OnErrorThrowable(t);
    }

    public static Throwable addValueAsLastCause(Throwable e2, Object value) {
        Throwable lastCause;
        if (e2 == null) {
            e2 = new NullPointerException();
        }
        if ((lastCause = Exceptions.getFinalCause(e2)) instanceof OnNextValue && ((OnNextValue)lastCause).getValue() == value) {
            return e2;
        }
        Exceptions.addCause(e2, new OnNextValue(value));
        return e2;
    }

    public static class OnNextValue
    extends RuntimeException {
        private static final long serialVersionUID = -3454462756050397899L;
        private final Object value;

        public OnNextValue(Object value) {
            super("OnError while emitting onNext value: " + OnNextValue.renderValue(value));
            Object v;
            if (value instanceof Serializable) {
                v = value;
            } else {
                try {
                    v = String.valueOf(value);
                }
                catch (Throwable ex) {
                    v = ex.getMessage();
                }
            }
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        static String renderValue(Object value) {
            if (value == null) {
                return "null";
            }
            if (Primitives.INSTANCE.contains(value.getClass())) {
                return value.toString();
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Enum) {
                return ((Enum)value).name();
            }
            String pluggedRendering = RxJavaPlugins.getInstance().getErrorHandler().handleOnNextValueRendering(value);
            if (pluggedRendering != null) {
                return pluggedRendering;
            }
            return value.getClass().getName() + ".class";
        }

        static final class Primitives {
            static final Set<Class<?>> INSTANCE = Primitives.create();

            Primitives() {
            }

            private static Set<Class<?>> create() {
                HashSet set2 = new HashSet();
                set2.add(Boolean.class);
                set2.add(Character.class);
                set2.add(Byte.class);
                set2.add(Short.class);
                set2.add(Integer.class);
                set2.add(Long.class);
                set2.add(Float.class);
                set2.add(Double.class);
                return set2;
            }
        }
    }
}

